<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PrintInvoice StructType
 * @subpackage Structs
 */
class PrintInvoice extends AbstractStructBase
{
    /**
     * The InvoiceNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $InvoiceNumber;
    /**
     * The UserName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UserName;
    /**
     * The Password
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * The InvoiceNumberList
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceNumberList;
    /**
     * Constructor method for PrintInvoice
     * @uses PrintInvoice::setInvoiceNumber()
     * @uses PrintInvoice::setUserName()
     * @uses PrintInvoice::setPassword()
     * @uses PrintInvoice::setInvoiceNumberList()
     * @param int $invoiceNumber
     * @param string $userName
     * @param string $password
     * @param string $invoiceNumberList
     */
    public function __construct($invoiceNumber = null, $userName = null, $password = null, $invoiceNumberList = null)
    {
        $this
            ->setInvoiceNumber($invoiceNumber)
            ->setUserName($userName)
            ->setPassword($password)
            ->setInvoiceNumberList($invoiceNumberList);
    }
    /**
     * Get InvoiceNumber value
     * @return int
     */
    public function getInvoiceNumber()
    {
        return $this->InvoiceNumber;
    }
    /**
     * Set InvoiceNumber value
     * @param int $invoiceNumber
     * @return \StructType\PrintInvoice
     */
    public function setInvoiceNumber($invoiceNumber = null)
    {
        // validation for constraint: int
        if (!is_null($invoiceNumber) && !(is_int($invoiceNumber) || ctype_digit($invoiceNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($invoiceNumber, true), gettype($invoiceNumber)), __LINE__);
        }
        $this->InvoiceNumber = $invoiceNumber;
        return $this;
    }
    /**
     * Get UserName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->UserName;
    }
    /**
     * Set UserName value
     * @param string $userName
     * @return \StructType\PrintInvoice
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userName, true), gettype($userName)), __LINE__);
        }
        $this->UserName = $userName;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\PrintInvoice
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get InvoiceNumberList value
     * @return string|null
     */
    public function getInvoiceNumberList()
    {
        return $this->InvoiceNumberList;
    }
    /**
     * Set InvoiceNumberList value
     * @param string $invoiceNumberList
     * @return \StructType\PrintInvoice
     */
    public function setInvoiceNumberList($invoiceNumberList = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceNumberList) && !is_string($invoiceNumberList)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceNumberList, true), gettype($invoiceNumberList)), __LINE__);
        }
        $this->InvoiceNumberList = $invoiceNumberList;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PrintInvoice
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
