<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payment StructType
 * @subpackage Structs
 */
class Payment extends AbstractStructBase
{
    /**
     * The PayID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PayID;
    /**
     * The PayInvoice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PayInvoice;
    /**
     * The PayDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PayDate;
    /**
     * The PayMethod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PayMethod;
    /**
     * The PayAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PayAccount;
    /**
     * The PayAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $PayAmount;
    /**
     * The PayNote
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PayNote;
    /**
     * Constructor method for Payment
     * @uses Payment::setPayID()
     * @uses Payment::setPayInvoice()
     * @uses Payment::setPayDate()
     * @uses Payment::setPayMethod()
     * @uses Payment::setPayAccount()
     * @uses Payment::setPayAmount()
     * @uses Payment::setPayNote()
     * @param int $payID
     * @param int $payInvoice
     * @param string $payDate
     * @param int $payMethod
     * @param int $payAccount
     * @param float $payAmount
     * @param string $payNote
     */
    public function __construct($payID = null, $payInvoice = null, $payDate = null, $payMethod = null, $payAccount = null, $payAmount = null, $payNote = null)
    {
        $this
            ->setPayID($payID)
            ->setPayInvoice($payInvoice)
            ->setPayDate($payDate)
            ->setPayMethod($payMethod)
            ->setPayAccount($payAccount)
            ->setPayAmount($payAmount)
            ->setPayNote($payNote);
    }
    /**
     * Get PayID value
     * @return int
     */
    public function getPayID()
    {
        return $this->PayID;
    }
    /**
     * Set PayID value
     * @param int $payID
     * @return \StructType\Payment
     */
    public function setPayID($payID = null)
    {
        // validation for constraint: int
        if (!is_null($payID) && !(is_int($payID) || ctype_digit($payID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($payID, true), gettype($payID)), __LINE__);
        }
        $this->PayID = $payID;
        return $this;
    }
    /**
     * Get PayInvoice value
     * @return int
     */
    public function getPayInvoice()
    {
        return $this->PayInvoice;
    }
    /**
     * Set PayInvoice value
     * @param int $payInvoice
     * @return \StructType\Payment
     */
    public function setPayInvoice($payInvoice = null)
    {
        // validation for constraint: int
        if (!is_null($payInvoice) && !(is_int($payInvoice) || ctype_digit($payInvoice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($payInvoice, true), gettype($payInvoice)), __LINE__);
        }
        $this->PayInvoice = $payInvoice;
        return $this;
    }
    /**
     * Get PayDate value
     * @return string
     */
    public function getPayDate()
    {
        return $this->PayDate;
    }
    /**
     * Set PayDate value
     * @param string $payDate
     * @return \StructType\Payment
     */
    public function setPayDate($payDate = null)
    {
        // validation for constraint: string
        if (!is_null($payDate) && !is_string($payDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payDate, true), gettype($payDate)), __LINE__);
        }
        $this->PayDate = $payDate;
        return $this;
    }
    /**
     * Get PayMethod value
     * @return int
     */
    public function getPayMethod()
    {
        return $this->PayMethod;
    }
    /**
     * Set PayMethod value
     * @param int $payMethod
     * @return \StructType\Payment
     */
    public function setPayMethod($payMethod = null)
    {
        // validation for constraint: int
        if (!is_null($payMethod) && !(is_int($payMethod) || ctype_digit($payMethod))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($payMethod, true), gettype($payMethod)), __LINE__);
        }
        $this->PayMethod = $payMethod;
        return $this;
    }
    /**
     * Get PayAccount value
     * @return int
     */
    public function getPayAccount()
    {
        return $this->PayAccount;
    }
    /**
     * Set PayAccount value
     * @param int $payAccount
     * @return \StructType\Payment
     */
    public function setPayAccount($payAccount = null)
    {
        // validation for constraint: int
        if (!is_null($payAccount) && !(is_int($payAccount) || ctype_digit($payAccount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($payAccount, true), gettype($payAccount)), __LINE__);
        }
        $this->PayAccount = $payAccount;
        return $this;
    }
    /**
     * Get PayAmount value
     * @return float
     */
    public function getPayAmount()
    {
        return $this->PayAmount;
    }
    /**
     * Set PayAmount value
     * @param float $payAmount
     * @return \StructType\Payment
     */
    public function setPayAmount($payAmount = null)
    {
        // validation for constraint: float
        if (!is_null($payAmount) && !(is_float($payAmount) || is_numeric($payAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($payAmount, true), gettype($payAmount)), __LINE__);
        }
        $this->PayAmount = $payAmount;
        return $this;
    }
    /**
     * Get PayNote value
     * @return string|null
     */
    public function getPayNote()
    {
        return $this->PayNote;
    }
    /**
     * Set PayNote value
     * @param string $payNote
     * @return \StructType\Payment
     */
    public function setPayNote($payNote = null)
    {
        // validation for constraint: string
        if (!is_null($payNote) && !is_string($payNote)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payNote, true), gettype($payNote)), __LINE__);
        }
        $this->PayNote = $payNote;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Payment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
