<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoiceLine StructType
 * @subpackage Structs
 */
class InvoiceLine extends AbstractStructBase
{
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Quantity;
    /**
     * The Rate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Rate;
    /**
     * The ChargeType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ChargeType;
    /**
     * The VatRate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $VatRate;
    /**
     * The VatAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $VatAmount;
    /**
     * The ProductID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ProductID;
    /**
     * The Sort
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Sort;
    /**
     * The ProjID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ProjID;
    /**
     * The LineID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $LineID;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The ValuesInCurrency
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $ValuesInCurrency;
    /**
     * Constructor method for InvoiceLine
     * @uses InvoiceLine::setQuantity()
     * @uses InvoiceLine::setRate()
     * @uses InvoiceLine::setChargeType()
     * @uses InvoiceLine::setVatRate()
     * @uses InvoiceLine::setVatAmount()
     * @uses InvoiceLine::setProductID()
     * @uses InvoiceLine::setSort()
     * @uses InvoiceLine::setProjID()
     * @uses InvoiceLine::setLineID()
     * @uses InvoiceLine::setDescription()
     * @uses InvoiceLine::setValuesInCurrency()
     * @param float $quantity
     * @param float $rate
     * @param int $chargeType
     * @param float $vatRate
     * @param float $vatAmount
     * @param int $productID
     * @param int $sort
     * @param int $projID
     * @param int $lineID
     * @param string $description
     * @param int $valuesInCurrency
     */
    public function __construct($quantity = null, $rate = null, $chargeType = null, $vatRate = null, $vatAmount = null, $productID = null, $sort = null, $projID = null, $lineID = null, $description = null, $valuesInCurrency = null)
    {
        $this
            ->setQuantity($quantity)
            ->setRate($rate)
            ->setChargeType($chargeType)
            ->setVatRate($vatRate)
            ->setVatAmount($vatAmount)
            ->setProductID($productID)
            ->setSort($sort)
            ->setProjID($projID)
            ->setLineID($lineID)
            ->setDescription($description)
            ->setValuesInCurrency($valuesInCurrency);
    }
    /**
     * Get Quantity value
     * @return float
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param float $quantity
     * @return \StructType\InvoiceLine
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: float
        if (!is_null($quantity) && !(is_float($quantity) || is_numeric($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get Rate value
     * @return float
     */
    public function getRate()
    {
        return $this->Rate;
    }
    /**
     * Set Rate value
     * @param float $rate
     * @return \StructType\InvoiceLine
     */
    public function setRate($rate = null)
    {
        // validation for constraint: float
        if (!is_null($rate) && !(is_float($rate) || is_numeric($rate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($rate, true), gettype($rate)), __LINE__);
        }
        $this->Rate = $rate;
        return $this;
    }
    /**
     * Get ChargeType value
     * @return int
     */
    public function getChargeType()
    {
        return $this->ChargeType;
    }
    /**
     * Set ChargeType value
     * @param int $chargeType
     * @return \StructType\InvoiceLine
     */
    public function setChargeType($chargeType = null)
    {
        // validation for constraint: int
        if (!is_null($chargeType) && !(is_int($chargeType) || ctype_digit($chargeType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($chargeType, true), gettype($chargeType)), __LINE__);
        }
        $this->ChargeType = $chargeType;
        return $this;
    }
    /**
     * Get VatRate value
     * @return float
     */
    public function getVatRate()
    {
        return $this->VatRate;
    }
    /**
     * Set VatRate value
     * @param float $vatRate
     * @return \StructType\InvoiceLine
     */
    public function setVatRate($vatRate = null)
    {
        // validation for constraint: float
        if (!is_null($vatRate) && !(is_float($vatRate) || is_numeric($vatRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($vatRate, true), gettype($vatRate)), __LINE__);
        }
        $this->VatRate = $vatRate;
        return $this;
    }
    /**
     * Get VatAmount value
     * @return float
     */
    public function getVatAmount()
    {
        return $this->VatAmount;
    }
    /**
     * Set VatAmount value
     * @param float $vatAmount
     * @return \StructType\InvoiceLine
     */
    public function setVatAmount($vatAmount = null)
    {
        // validation for constraint: float
        if (!is_null($vatAmount) && !(is_float($vatAmount) || is_numeric($vatAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($vatAmount, true), gettype($vatAmount)), __LINE__);
        }
        $this->VatAmount = $vatAmount;
        return $this;
    }
    /**
     * Get ProductID value
     * @return int
     */
    public function getProductID()
    {
        return $this->ProductID;
    }
    /**
     * Set ProductID value
     * @param int $productID
     * @return \StructType\InvoiceLine
     */
    public function setProductID($productID = null)
    {
        // validation for constraint: int
        if (!is_null($productID) && !(is_int($productID) || ctype_digit($productID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($productID, true), gettype($productID)), __LINE__);
        }
        $this->ProductID = $productID;
        return $this;
    }
    /**
     * Get Sort value
     * @return int
     */
    public function getSort()
    {
        return $this->Sort;
    }
    /**
     * Set Sort value
     * @param int $sort
     * @return \StructType\InvoiceLine
     */
    public function setSort($sort = null)
    {
        // validation for constraint: int
        if (!is_null($sort) && !(is_int($sort) || ctype_digit($sort))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sort, true), gettype($sort)), __LINE__);
        }
        $this->Sort = $sort;
        return $this;
    }
    /**
     * Get ProjID value
     * @return int
     */
    public function getProjID()
    {
        return $this->ProjID;
    }
    /**
     * Set ProjID value
     * @param int $projID
     * @return \StructType\InvoiceLine
     */
    public function setProjID($projID = null)
    {
        // validation for constraint: int
        if (!is_null($projID) && !(is_int($projID) || ctype_digit($projID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($projID, true), gettype($projID)), __LINE__);
        }
        $this->ProjID = $projID;
        return $this;
    }
    /**
     * Get LineID value
     * @return int
     */
    public function getLineID()
    {
        return $this->LineID;
    }
    /**
     * Set LineID value
     * @param int $lineID
     * @return \StructType\InvoiceLine
     */
    public function setLineID($lineID = null)
    {
        // validation for constraint: int
        if (!is_null($lineID) && !(is_int($lineID) || ctype_digit($lineID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lineID, true), gettype($lineID)), __LINE__);
        }
        $this->LineID = $lineID;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\InvoiceLine
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get ValuesInCurrency value
     * @return int|null
     */
    public function getValuesInCurrency()
    {
        return $this->ValuesInCurrency;
    }
    /**
     * Set ValuesInCurrency value
     * @param int $valuesInCurrency
     * @return \StructType\InvoiceLine
     */
    public function setValuesInCurrency($valuesInCurrency = null)
    {
        // validation for constraint: int
        if (!is_null($valuesInCurrency) && !(is_int($valuesInCurrency) || ctype_digit($valuesInCurrency))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($valuesInCurrency, true), gettype($valuesInCurrency)), __LINE__);
        }
        $this->ValuesInCurrency = $valuesInCurrency;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InvoiceLine
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
