<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InsertInvoiceLine StructType
 * @subpackage Structs
 */
class InsertInvoiceLine extends AbstractStructBase
{
    /**
     * The InvoiceID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $InvoiceID;
    /**
     * The UserName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UserName;
    /**
     * The Password
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * The InvLine
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\InvoiceLine
     */
    public $InvLine;
    /**
     * Constructor method for InsertInvoiceLine
     * @uses InsertInvoiceLine::setInvoiceID()
     * @uses InsertInvoiceLine::setUserName()
     * @uses InsertInvoiceLine::setPassword()
     * @uses InsertInvoiceLine::setInvLine()
     * @param int $invoiceID
     * @param string $userName
     * @param string $password
     * @param \StructType\InvoiceLine $invLine
     */
    public function __construct($invoiceID = null, $userName = null, $password = null, \StructType\InvoiceLine $invLine = null)
    {
        $this
            ->setInvoiceID($invoiceID)
            ->setUserName($userName)
            ->setPassword($password)
            ->setInvLine($invLine);
    }
    /**
     * Get InvoiceID value
     * @return int
     */
    public function getInvoiceID()
    {
        return $this->InvoiceID;
    }
    /**
     * Set InvoiceID value
     * @param int $invoiceID
     * @return \StructType\InsertInvoiceLine
     */
    public function setInvoiceID($invoiceID = null)
    {
        // validation for constraint: int
        if (!is_null($invoiceID) && !(is_int($invoiceID) || ctype_digit($invoiceID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($invoiceID, true), gettype($invoiceID)), __LINE__);
        }
        $this->InvoiceID = $invoiceID;
        return $this;
    }
    /**
     * Get UserName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->UserName;
    }
    /**
     * Set UserName value
     * @param string $userName
     * @return \StructType\InsertInvoiceLine
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userName, true), gettype($userName)), __LINE__);
        }
        $this->UserName = $userName;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\InsertInvoiceLine
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get InvLine value
     * @return \StructType\InvoiceLine|null
     */
    public function getInvLine()
    {
        return $this->InvLine;
    }
    /**
     * Set InvLine value
     * @param \StructType\InvoiceLine $invLine
     * @return \StructType\InsertInvoiceLine
     */
    public function setInvLine(\StructType\InvoiceLine $invLine = null)
    {
        $this->InvLine = $invLine;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InsertInvoiceLine
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
