<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EmailPurchaseOrder StructType
 * @subpackage Structs
 */
class EmailPurchaseOrder extends AbstractStructBase
{
    /**
     * The ReceiptNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ReceiptNumber;
    /**
     * The UserName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UserName;
    /**
     * The Password
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * The FromEmail
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FromEmail;
    /**
     * The FromName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FromName;
    /**
     * The SubjectLine
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SubjectLine;
    /**
     * The Body
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Body;
    /**
     * The RecipientEmail
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RecipientEmail;
    /**
     * Constructor method for EmailPurchaseOrder
     * @uses EmailPurchaseOrder::setReceiptNumber()
     * @uses EmailPurchaseOrder::setUserName()
     * @uses EmailPurchaseOrder::setPassword()
     * @uses EmailPurchaseOrder::setFromEmail()
     * @uses EmailPurchaseOrder::setFromName()
     * @uses EmailPurchaseOrder::setSubjectLine()
     * @uses EmailPurchaseOrder::setBody()
     * @uses EmailPurchaseOrder::setRecipientEmail()
     * @param int $receiptNumber
     * @param string $userName
     * @param string $password
     * @param string $fromEmail
     * @param string $fromName
     * @param string $subjectLine
     * @param string $body
     * @param string $recipientEmail
     */
    public function __construct($receiptNumber = null, $userName = null, $password = null, $fromEmail = null, $fromName = null, $subjectLine = null, $body = null, $recipientEmail = null)
    {
        $this
            ->setReceiptNumber($receiptNumber)
            ->setUserName($userName)
            ->setPassword($password)
            ->setFromEmail($fromEmail)
            ->setFromName($fromName)
            ->setSubjectLine($subjectLine)
            ->setBody($body)
            ->setRecipientEmail($recipientEmail);
    }
    /**
     * Get ReceiptNumber value
     * @return int
     */
    public function getReceiptNumber()
    {
        return $this->ReceiptNumber;
    }
    /**
     * Set ReceiptNumber value
     * @param int $receiptNumber
     * @return \StructType\EmailPurchaseOrder
     */
    public function setReceiptNumber($receiptNumber = null)
    {
        // validation for constraint: int
        if (!is_null($receiptNumber) && !(is_int($receiptNumber) || ctype_digit($receiptNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($receiptNumber, true), gettype($receiptNumber)), __LINE__);
        }
        $this->ReceiptNumber = $receiptNumber;
        return $this;
    }
    /**
     * Get UserName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->UserName;
    }
    /**
     * Set UserName value
     * @param string $userName
     * @return \StructType\EmailPurchaseOrder
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userName, true), gettype($userName)), __LINE__);
        }
        $this->UserName = $userName;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\EmailPurchaseOrder
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get FromEmail value
     * @return string|null
     */
    public function getFromEmail()
    {
        return $this->FromEmail;
    }
    /**
     * Set FromEmail value
     * @param string $fromEmail
     * @return \StructType\EmailPurchaseOrder
     */
    public function setFromEmail($fromEmail = null)
    {
        // validation for constraint: string
        if (!is_null($fromEmail) && !is_string($fromEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromEmail, true), gettype($fromEmail)), __LINE__);
        }
        $this->FromEmail = $fromEmail;
        return $this;
    }
    /**
     * Get FromName value
     * @return string|null
     */
    public function getFromName()
    {
        return $this->FromName;
    }
    /**
     * Set FromName value
     * @param string $fromName
     * @return \StructType\EmailPurchaseOrder
     */
    public function setFromName($fromName = null)
    {
        // validation for constraint: string
        if (!is_null($fromName) && !is_string($fromName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromName, true), gettype($fromName)), __LINE__);
        }
        $this->FromName = $fromName;
        return $this;
    }
    /**
     * Get SubjectLine value
     * @return string|null
     */
    public function getSubjectLine()
    {
        return $this->SubjectLine;
    }
    /**
     * Set SubjectLine value
     * @param string $subjectLine
     * @return \StructType\EmailPurchaseOrder
     */
    public function setSubjectLine($subjectLine = null)
    {
        // validation for constraint: string
        if (!is_null($subjectLine) && !is_string($subjectLine)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subjectLine, true), gettype($subjectLine)), __LINE__);
        }
        $this->SubjectLine = $subjectLine;
        return $this;
    }
    /**
     * Get Body value
     * @return string|null
     */
    public function getBody()
    {
        return $this->Body;
    }
    /**
     * Set Body value
     * @param string $body
     * @return \StructType\EmailPurchaseOrder
     */
    public function setBody($body = null)
    {
        // validation for constraint: string
        if (!is_null($body) && !is_string($body)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($body, true), gettype($body)), __LINE__);
        }
        $this->Body = $body;
        return $this;
    }
    /**
     * Get RecipientEmail value
     * @return string|null
     */
    public function getRecipientEmail()
    {
        return $this->RecipientEmail;
    }
    /**
     * Set RecipientEmail value
     * @param string $recipientEmail
     * @return \StructType\EmailPurchaseOrder
     */
    public function setRecipientEmail($recipientEmail = null)
    {
        // validation for constraint: string
        if (!is_null($recipientEmail) && !is_string($recipientEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recipientEmail, true), gettype($recipientEmail)), __LINE__);
        }
        $this->RecipientEmail = $recipientEmail;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EmailPurchaseOrder
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
