<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeleteReceiptPayment StructType
 * @subpackage Structs
 */
class DeleteReceiptPayment extends AbstractStructBase
{
    /**
     * The ReceiptPaymentNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ReceiptPaymentNumber;
    /**
     * The UserName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UserName;
    /**
     * The Password
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * Constructor method for DeleteReceiptPayment
     * @uses DeleteReceiptPayment::setReceiptPaymentNumber()
     * @uses DeleteReceiptPayment::setUserName()
     * @uses DeleteReceiptPayment::setPassword()
     * @param int $receiptPaymentNumber
     * @param string $userName
     * @param string $password
     */
    public function __construct($receiptPaymentNumber = null, $userName = null, $password = null)
    {
        $this
            ->setReceiptPaymentNumber($receiptPaymentNumber)
            ->setUserName($userName)
            ->setPassword($password);
    }
    /**
     * Get ReceiptPaymentNumber value
     * @return int
     */
    public function getReceiptPaymentNumber()
    {
        return $this->ReceiptPaymentNumber;
    }
    /**
     * Set ReceiptPaymentNumber value
     * @param int $receiptPaymentNumber
     * @return \StructType\DeleteReceiptPayment
     */
    public function setReceiptPaymentNumber($receiptPaymentNumber = null)
    {
        // validation for constraint: int
        if (!is_null($receiptPaymentNumber) && !(is_int($receiptPaymentNumber) || ctype_digit($receiptPaymentNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($receiptPaymentNumber, true), gettype($receiptPaymentNumber)), __LINE__);
        }
        $this->ReceiptPaymentNumber = $receiptPaymentNumber;
        return $this;
    }
    /**
     * Get UserName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->UserName;
    }
    /**
     * Set UserName value
     * @param string $userName
     * @return \StructType\DeleteReceiptPayment
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userName, true), gettype($userName)), __LINE__);
        }
        $this->UserName = $userName;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\DeleteReceiptPayment
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DeleteReceiptPayment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
