<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeleteReceiptLine StructType
 * @subpackage Structs
 */
class DeleteReceiptLine extends AbstractStructBase
{
    /**
     * The LineID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $LineID;
    /**
     * The ReceiptNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ReceiptNumber;
    /**
     * The UserName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UserName;
    /**
     * The Password
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * Constructor method for DeleteReceiptLine
     * @uses DeleteReceiptLine::setLineID()
     * @uses DeleteReceiptLine::setReceiptNumber()
     * @uses DeleteReceiptLine::setUserName()
     * @uses DeleteReceiptLine::setPassword()
     * @param int $lineID
     * @param int $receiptNumber
     * @param string $userName
     * @param string $password
     */
    public function __construct($lineID = null, $receiptNumber = null, $userName = null, $password = null)
    {
        $this
            ->setLineID($lineID)
            ->setReceiptNumber($receiptNumber)
            ->setUserName($userName)
            ->setPassword($password);
    }
    /**
     * Get LineID value
     * @return int
     */
    public function getLineID()
    {
        return $this->LineID;
    }
    /**
     * Set LineID value
     * @param int $lineID
     * @return \StructType\DeleteReceiptLine
     */
    public function setLineID($lineID = null)
    {
        // validation for constraint: int
        if (!is_null($lineID) && !(is_int($lineID) || ctype_digit($lineID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lineID, true), gettype($lineID)), __LINE__);
        }
        $this->LineID = $lineID;
        return $this;
    }
    /**
     * Get ReceiptNumber value
     * @return int
     */
    public function getReceiptNumber()
    {
        return $this->ReceiptNumber;
    }
    /**
     * Set ReceiptNumber value
     * @param int $receiptNumber
     * @return \StructType\DeleteReceiptLine
     */
    public function setReceiptNumber($receiptNumber = null)
    {
        // validation for constraint: int
        if (!is_null($receiptNumber) && !(is_int($receiptNumber) || ctype_digit($receiptNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($receiptNumber, true), gettype($receiptNumber)), __LINE__);
        }
        $this->ReceiptNumber = $receiptNumber;
        return $this;
    }
    /**
     * Get UserName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->UserName;
    }
    /**
     * Set UserName value
     * @param string $userName
     * @return \StructType\DeleteReceiptLine
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userName, true), gettype($userName)), __LINE__);
        }
        $this->UserName = $userName;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\DeleteReceiptLine
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DeleteReceiptLine
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
