<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeleteReceiptAttachment StructType
 * @subpackage Structs
 */
class DeleteReceiptAttachment extends AbstractStructBase
{
    /**
     * The ReceiptID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ReceiptID;
    /**
     * The AttachmentID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AttachmentID;
    /**
     * The UserName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UserName;
    /**
     * The Password
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * Constructor method for DeleteReceiptAttachment
     * @uses DeleteReceiptAttachment::setReceiptID()
     * @uses DeleteReceiptAttachment::setAttachmentID()
     * @uses DeleteReceiptAttachment::setUserName()
     * @uses DeleteReceiptAttachment::setPassword()
     * @param int $receiptID
     * @param int $attachmentID
     * @param string $userName
     * @param string $password
     */
    public function __construct($receiptID = null, $attachmentID = null, $userName = null, $password = null)
    {
        $this
            ->setReceiptID($receiptID)
            ->setAttachmentID($attachmentID)
            ->setUserName($userName)
            ->setPassword($password);
    }
    /**
     * Get ReceiptID value
     * @return int
     */
    public function getReceiptID()
    {
        return $this->ReceiptID;
    }
    /**
     * Set ReceiptID value
     * @param int $receiptID
     * @return \StructType\DeleteReceiptAttachment
     */
    public function setReceiptID($receiptID = null)
    {
        // validation for constraint: int
        if (!is_null($receiptID) && !(is_int($receiptID) || ctype_digit($receiptID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($receiptID, true), gettype($receiptID)), __LINE__);
        }
        $this->ReceiptID = $receiptID;
        return $this;
    }
    /**
     * Get AttachmentID value
     * @return int
     */
    public function getAttachmentID()
    {
        return $this->AttachmentID;
    }
    /**
     * Set AttachmentID value
     * @param int $attachmentID
     * @return \StructType\DeleteReceiptAttachment
     */
    public function setAttachmentID($attachmentID = null)
    {
        // validation for constraint: int
        if (!is_null($attachmentID) && !(is_int($attachmentID) || ctype_digit($attachmentID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($attachmentID, true), gettype($attachmentID)), __LINE__);
        }
        $this->AttachmentID = $attachmentID;
        return $this;
    }
    /**
     * Get UserName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->UserName;
    }
    /**
     * Set UserName value
     * @param string $userName
     * @return \StructType\DeleteReceiptAttachment
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userName, true), gettype($userName)), __LINE__);
        }
        $this->UserName = $userName;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\DeleteReceiptAttachment
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DeleteReceiptAttachment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
