<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeleteInvoicePayment StructType
 * @subpackage Structs
 */
class DeleteInvoicePayment extends AbstractStructBase
{
    /**
     * The InvoicePaymentNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $InvoicePaymentNumber;
    /**
     * The UserName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UserName;
    /**
     * The Password
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * Constructor method for DeleteInvoicePayment
     * @uses DeleteInvoicePayment::setInvoicePaymentNumber()
     * @uses DeleteInvoicePayment::setUserName()
     * @uses DeleteInvoicePayment::setPassword()
     * @param int $invoicePaymentNumber
     * @param string $userName
     * @param string $password
     */
    public function __construct($invoicePaymentNumber = null, $userName = null, $password = null)
    {
        $this
            ->setInvoicePaymentNumber($invoicePaymentNumber)
            ->setUserName($userName)
            ->setPassword($password);
    }
    /**
     * Get InvoicePaymentNumber value
     * @return int
     */
    public function getInvoicePaymentNumber()
    {
        return $this->InvoicePaymentNumber;
    }
    /**
     * Set InvoicePaymentNumber value
     * @param int $invoicePaymentNumber
     * @return \StructType\DeleteInvoicePayment
     */
    public function setInvoicePaymentNumber($invoicePaymentNumber = null)
    {
        // validation for constraint: int
        if (!is_null($invoicePaymentNumber) && !(is_int($invoicePaymentNumber) || ctype_digit($invoicePaymentNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($invoicePaymentNumber, true), gettype($invoicePaymentNumber)), __LINE__);
        }
        $this->InvoicePaymentNumber = $invoicePaymentNumber;
        return $this;
    }
    /**
     * Get UserName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->UserName;
    }
    /**
     * Set UserName value
     * @param string $userName
     * @return \StructType\DeleteInvoicePayment
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userName, true), gettype($userName)), __LINE__);
        }
        $this->UserName = $userName;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\DeleteInvoicePayment
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DeleteInvoicePayment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
