<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BankTransaction StructType
 * @subpackage Structs
 */
class BankTransaction extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ID;
    /**
     * The accid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $accid;
    /**
     * The TransactionDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TransactionDate;
    /**
     * The moneyin
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $moneyin;
    /**
     * The moneyout
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $moneyout;
    /**
     * The Vatable
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Vatable;
    /**
     * The VatRate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $VatRate;
    /**
     * The VatAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $VatAmount;
    /**
     * The TransactionType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TransactionType;
    /**
     * The ProjectID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ProjectID;
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerId;
    /**
     * The SupplierId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SupplierId;
    /**
     * The Comment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Comment;
    /**
     * Constructor method for BankTransaction
     * @uses BankTransaction::setID()
     * @uses BankTransaction::setAccid()
     * @uses BankTransaction::setTransactionDate()
     * @uses BankTransaction::setMoneyin()
     * @uses BankTransaction::setMoneyout()
     * @uses BankTransaction::setVatable()
     * @uses BankTransaction::setVatRate()
     * @uses BankTransaction::setVatAmount()
     * @uses BankTransaction::setTransactionType()
     * @uses BankTransaction::setProjectID()
     * @uses BankTransaction::setCustomerId()
     * @uses BankTransaction::setSupplierId()
     * @uses BankTransaction::setComment()
     * @param int $iD
     * @param int $accid
     * @param string $transactionDate
     * @param float $moneyin
     * @param float $moneyout
     * @param int $vatable
     * @param float $vatRate
     * @param float $vatAmount
     * @param int $transactionType
     * @param int $projectID
     * @param int $customerId
     * @param int $supplierId
     * @param string $comment
     */
    public function __construct($iD = null, $accid = null, $transactionDate = null, $moneyin = null, $moneyout = null, $vatable = null, $vatRate = null, $vatAmount = null, $transactionType = null, $projectID = null, $customerId = null, $supplierId = null, $comment = null)
    {
        $this
            ->setID($iD)
            ->setAccid($accid)
            ->setTransactionDate($transactionDate)
            ->setMoneyin($moneyin)
            ->setMoneyout($moneyout)
            ->setVatable($vatable)
            ->setVatRate($vatRate)
            ->setVatAmount($vatAmount)
            ->setTransactionType($transactionType)
            ->setProjectID($projectID)
            ->setCustomerId($customerId)
            ->setSupplierId($supplierId)
            ->setComment($comment);
    }
    /**
     * Get ID value
     * @return int
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\BankTransaction
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !(is_int($iD) || ctype_digit($iD))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get accid value
     * @return int
     */
    public function getAccid()
    {
        return $this->accid;
    }
    /**
     * Set accid value
     * @param int $accid
     * @return \StructType\BankTransaction
     */
    public function setAccid($accid = null)
    {
        // validation for constraint: int
        if (!is_null($accid) && !(is_int($accid) || ctype_digit($accid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($accid, true), gettype($accid)), __LINE__);
        }
        $this->accid = $accid;
        return $this;
    }
    /**
     * Get TransactionDate value
     * @return string
     */
    public function getTransactionDate()
    {
        return $this->TransactionDate;
    }
    /**
     * Set TransactionDate value
     * @param string $transactionDate
     * @return \StructType\BankTransaction
     */
    public function setTransactionDate($transactionDate = null)
    {
        // validation for constraint: string
        if (!is_null($transactionDate) && !is_string($transactionDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionDate, true), gettype($transactionDate)), __LINE__);
        }
        $this->TransactionDate = $transactionDate;
        return $this;
    }
    /**
     * Get moneyin value
     * @return float
     */
    public function getMoneyin()
    {
        return $this->moneyin;
    }
    /**
     * Set moneyin value
     * @param float $moneyin
     * @return \StructType\BankTransaction
     */
    public function setMoneyin($moneyin = null)
    {
        // validation for constraint: float
        if (!is_null($moneyin) && !(is_float($moneyin) || is_numeric($moneyin))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($moneyin, true), gettype($moneyin)), __LINE__);
        }
        $this->moneyin = $moneyin;
        return $this;
    }
    /**
     * Get moneyout value
     * @return float
     */
    public function getMoneyout()
    {
        return $this->moneyout;
    }
    /**
     * Set moneyout value
     * @param float $moneyout
     * @return \StructType\BankTransaction
     */
    public function setMoneyout($moneyout = null)
    {
        // validation for constraint: float
        if (!is_null($moneyout) && !(is_float($moneyout) || is_numeric($moneyout))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($moneyout, true), gettype($moneyout)), __LINE__);
        }
        $this->moneyout = $moneyout;
        return $this;
    }
    /**
     * Get Vatable value
     * @return int
     */
    public function getVatable()
    {
        return $this->Vatable;
    }
    /**
     * Set Vatable value
     * @param int $vatable
     * @return \StructType\BankTransaction
     */
    public function setVatable($vatable = null)
    {
        // validation for constraint: int
        if (!is_null($vatable) && !(is_int($vatable) || ctype_digit($vatable))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($vatable, true), gettype($vatable)), __LINE__);
        }
        $this->Vatable = $vatable;
        return $this;
    }
    /**
     * Get VatRate value
     * @return float
     */
    public function getVatRate()
    {
        return $this->VatRate;
    }
    /**
     * Set VatRate value
     * @param float $vatRate
     * @return \StructType\BankTransaction
     */
    public function setVatRate($vatRate = null)
    {
        // validation for constraint: float
        if (!is_null($vatRate) && !(is_float($vatRate) || is_numeric($vatRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($vatRate, true), gettype($vatRate)), __LINE__);
        }
        $this->VatRate = $vatRate;
        return $this;
    }
    /**
     * Get VatAmount value
     * @return float
     */
    public function getVatAmount()
    {
        return $this->VatAmount;
    }
    /**
     * Set VatAmount value
     * @param float $vatAmount
     * @return \StructType\BankTransaction
     */
    public function setVatAmount($vatAmount = null)
    {
        // validation for constraint: float
        if (!is_null($vatAmount) && !(is_float($vatAmount) || is_numeric($vatAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($vatAmount, true), gettype($vatAmount)), __LINE__);
        }
        $this->VatAmount = $vatAmount;
        return $this;
    }
    /**
     * Get TransactionType value
     * @return int
     */
    public function getTransactionType()
    {
        return $this->TransactionType;
    }
    /**
     * Set TransactionType value
     * @param int $transactionType
     * @return \StructType\BankTransaction
     */
    public function setTransactionType($transactionType = null)
    {
        // validation for constraint: int
        if (!is_null($transactionType) && !(is_int($transactionType) || ctype_digit($transactionType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionType, true), gettype($transactionType)), __LINE__);
        }
        $this->TransactionType = $transactionType;
        return $this;
    }
    /**
     * Get ProjectID value
     * @return int
     */
    public function getProjectID()
    {
        return $this->ProjectID;
    }
    /**
     * Set ProjectID value
     * @param int $projectID
     * @return \StructType\BankTransaction
     */
    public function setProjectID($projectID = null)
    {
        // validation for constraint: int
        if (!is_null($projectID) && !(is_int($projectID) || ctype_digit($projectID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($projectID, true), gettype($projectID)), __LINE__);
        }
        $this->ProjectID = $projectID;
        return $this;
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \StructType\BankTransaction
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get SupplierId value
     * @return int
     */
    public function getSupplierId()
    {
        return $this->SupplierId;
    }
    /**
     * Set SupplierId value
     * @param int $supplierId
     * @return \StructType\BankTransaction
     */
    public function setSupplierId($supplierId = null)
    {
        // validation for constraint: int
        if (!is_null($supplierId) && !(is_int($supplierId) || ctype_digit($supplierId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($supplierId, true), gettype($supplierId)), __LINE__);
        }
        $this->SupplierId = $supplierId;
        return $this;
    }
    /**
     * Get Comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->Comment;
    }
    /**
     * Set Comment value
     * @param string $comment
     * @return \StructType\BankTransaction
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comment, true), gettype($comment)), __LINE__);
        }
        $this->Comment = $comment;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BankTransaction
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
