<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BalanceSheet StructType
 * @subpackage Structs
 */
class BalanceSheet extends AbstractStructBase
{
    /**
     * The Date
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Date;
    /**
     * The FixedAssetsTotal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $FixedAssetsTotal;
    /**
     * The CurrentAssetsTotal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $CurrentAssetsTotal;
    /**
     * The CurrentLiabilitiesTotal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $CurrentLiabilitiesTotal;
    /**
     * The CapitalReservesTotal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $CapitalReservesTotal;
    /**
     * The FixedAssets
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfAnyType
     */
    public $FixedAssets;
    /**
     * The CurrentAssets
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfAnyType
     */
    public $CurrentAssets;
    /**
     * The CurrentLiabilities
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfAnyType
     */
    public $CurrentLiabilities;
    /**
     * The CapitalReserves
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfAnyType
     */
    public $CapitalReserves;
    /**
     * Constructor method for BalanceSheet
     * @uses BalanceSheet::setDate()
     * @uses BalanceSheet::setFixedAssetsTotal()
     * @uses BalanceSheet::setCurrentAssetsTotal()
     * @uses BalanceSheet::setCurrentLiabilitiesTotal()
     * @uses BalanceSheet::setCapitalReservesTotal()
     * @uses BalanceSheet::setFixedAssets()
     * @uses BalanceSheet::setCurrentAssets()
     * @uses BalanceSheet::setCurrentLiabilities()
     * @uses BalanceSheet::setCapitalReserves()
     * @param string $date
     * @param float $fixedAssetsTotal
     * @param float $currentAssetsTotal
     * @param float $currentLiabilitiesTotal
     * @param float $capitalReservesTotal
     * @param \ArrayType\ArrayOfAnyType $fixedAssets
     * @param \ArrayType\ArrayOfAnyType $currentAssets
     * @param \ArrayType\ArrayOfAnyType $currentLiabilities
     * @param \ArrayType\ArrayOfAnyType $capitalReserves
     */
    public function __construct($date = null, $fixedAssetsTotal = null, $currentAssetsTotal = null, $currentLiabilitiesTotal = null, $capitalReservesTotal = null, \ArrayType\ArrayOfAnyType $fixedAssets = null, \ArrayType\ArrayOfAnyType $currentAssets = null, \ArrayType\ArrayOfAnyType $currentLiabilities = null, \ArrayType\ArrayOfAnyType $capitalReserves = null)
    {
        $this
            ->setDate($date)
            ->setFixedAssetsTotal($fixedAssetsTotal)
            ->setCurrentAssetsTotal($currentAssetsTotal)
            ->setCurrentLiabilitiesTotal($currentLiabilitiesTotal)
            ->setCapitalReservesTotal($capitalReservesTotal)
            ->setFixedAssets($fixedAssets)
            ->setCurrentAssets($currentAssets)
            ->setCurrentLiabilities($currentLiabilities)
            ->setCapitalReserves($capitalReserves);
    }
    /**
     * Get Date value
     * @return string
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \StructType\BalanceSheet
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Get FixedAssetsTotal value
     * @return float
     */
    public function getFixedAssetsTotal()
    {
        return $this->FixedAssetsTotal;
    }
    /**
     * Set FixedAssetsTotal value
     * @param float $fixedAssetsTotal
     * @return \StructType\BalanceSheet
     */
    public function setFixedAssetsTotal($fixedAssetsTotal = null)
    {
        // validation for constraint: float
        if (!is_null($fixedAssetsTotal) && !(is_float($fixedAssetsTotal) || is_numeric($fixedAssetsTotal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fixedAssetsTotal, true), gettype($fixedAssetsTotal)), __LINE__);
        }
        $this->FixedAssetsTotal = $fixedAssetsTotal;
        return $this;
    }
    /**
     * Get CurrentAssetsTotal value
     * @return float
     */
    public function getCurrentAssetsTotal()
    {
        return $this->CurrentAssetsTotal;
    }
    /**
     * Set CurrentAssetsTotal value
     * @param float $currentAssetsTotal
     * @return \StructType\BalanceSheet
     */
    public function setCurrentAssetsTotal($currentAssetsTotal = null)
    {
        // validation for constraint: float
        if (!is_null($currentAssetsTotal) && !(is_float($currentAssetsTotal) || is_numeric($currentAssetsTotal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($currentAssetsTotal, true), gettype($currentAssetsTotal)), __LINE__);
        }
        $this->CurrentAssetsTotal = $currentAssetsTotal;
        return $this;
    }
    /**
     * Get CurrentLiabilitiesTotal value
     * @return float
     */
    public function getCurrentLiabilitiesTotal()
    {
        return $this->CurrentLiabilitiesTotal;
    }
    /**
     * Set CurrentLiabilitiesTotal value
     * @param float $currentLiabilitiesTotal
     * @return \StructType\BalanceSheet
     */
    public function setCurrentLiabilitiesTotal($currentLiabilitiesTotal = null)
    {
        // validation for constraint: float
        if (!is_null($currentLiabilitiesTotal) && !(is_float($currentLiabilitiesTotal) || is_numeric($currentLiabilitiesTotal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($currentLiabilitiesTotal, true), gettype($currentLiabilitiesTotal)), __LINE__);
        }
        $this->CurrentLiabilitiesTotal = $currentLiabilitiesTotal;
        return $this;
    }
    /**
     * Get CapitalReservesTotal value
     * @return float
     */
    public function getCapitalReservesTotal()
    {
        return $this->CapitalReservesTotal;
    }
    /**
     * Set CapitalReservesTotal value
     * @param float $capitalReservesTotal
     * @return \StructType\BalanceSheet
     */
    public function setCapitalReservesTotal($capitalReservesTotal = null)
    {
        // validation for constraint: float
        if (!is_null($capitalReservesTotal) && !(is_float($capitalReservesTotal) || is_numeric($capitalReservesTotal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($capitalReservesTotal, true), gettype($capitalReservesTotal)), __LINE__);
        }
        $this->CapitalReservesTotal = $capitalReservesTotal;
        return $this;
    }
    /**
     * Get FixedAssets value
     * @return \ArrayType\ArrayOfAnyType|null
     */
    public function getFixedAssets()
    {
        return $this->FixedAssets;
    }
    /**
     * Set FixedAssets value
     * @param \ArrayType\ArrayOfAnyType $fixedAssets
     * @return \StructType\BalanceSheet
     */
    public function setFixedAssets(\ArrayType\ArrayOfAnyType $fixedAssets = null)
    {
        $this->FixedAssets = $fixedAssets;
        return $this;
    }
    /**
     * Get CurrentAssets value
     * @return \ArrayType\ArrayOfAnyType|null
     */
    public function getCurrentAssets()
    {
        return $this->CurrentAssets;
    }
    /**
     * Set CurrentAssets value
     * @param \ArrayType\ArrayOfAnyType $currentAssets
     * @return \StructType\BalanceSheet
     */
    public function setCurrentAssets(\ArrayType\ArrayOfAnyType $currentAssets = null)
    {
        $this->CurrentAssets = $currentAssets;
        return $this;
    }
    /**
     * Get CurrentLiabilities value
     * @return \ArrayType\ArrayOfAnyType|null
     */
    public function getCurrentLiabilities()
    {
        return $this->CurrentLiabilities;
    }
    /**
     * Set CurrentLiabilities value
     * @param \ArrayType\ArrayOfAnyType $currentLiabilities
     * @return \StructType\BalanceSheet
     */
    public function setCurrentLiabilities(\ArrayType\ArrayOfAnyType $currentLiabilities = null)
    {
        $this->CurrentLiabilities = $currentLiabilities;
        return $this;
    }
    /**
     * Get CapitalReserves value
     * @return \ArrayType\ArrayOfAnyType|null
     */
    public function getCapitalReserves()
    {
        return $this->CapitalReserves;
    }
    /**
     * Set CapitalReserves value
     * @param \ArrayType\ArrayOfAnyType $capitalReserves
     * @return \StructType\BalanceSheet
     */
    public function setCapitalReserves(\ArrayType\ArrayOfAnyType $capitalReserves = null)
    {
        $this->CapitalReserves = $capitalReserves;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BalanceSheet
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
