<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AttachFileToReceipt StructType
 * @subpackage Structs
 */
class AttachFileToReceipt extends AbstractStructBase
{
    /**
     * The ReceiptNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ReceiptNo;
    /**
     * The UserName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UserName;
    /**
     * The Password
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * The Base64String
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Base64String;
    /**
     * The ContentType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ContentType;
    /**
     * The Filename
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Filename;
    /**
     * The FileExtension
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FileExtension;
    /**
     * The FileSize
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FileSize;
    /**
     * Constructor method for AttachFileToReceipt
     * @uses AttachFileToReceipt::setReceiptNo()
     * @uses AttachFileToReceipt::setUserName()
     * @uses AttachFileToReceipt::setPassword()
     * @uses AttachFileToReceipt::setBase64String()
     * @uses AttachFileToReceipt::setContentType()
     * @uses AttachFileToReceipt::setFilename()
     * @uses AttachFileToReceipt::setFileExtension()
     * @uses AttachFileToReceipt::setFileSize()
     * @param int $receiptNo
     * @param string $userName
     * @param string $password
     * @param string $base64String
     * @param string $contentType
     * @param string $filename
     * @param string $fileExtension
     * @param string $fileSize
     */
    public function __construct($receiptNo = null, $userName = null, $password = null, $base64String = null, $contentType = null, $filename = null, $fileExtension = null, $fileSize = null)
    {
        $this
            ->setReceiptNo($receiptNo)
            ->setUserName($userName)
            ->setPassword($password)
            ->setBase64String($base64String)
            ->setContentType($contentType)
            ->setFilename($filename)
            ->setFileExtension($fileExtension)
            ->setFileSize($fileSize);
    }
    /**
     * Get ReceiptNo value
     * @return int
     */
    public function getReceiptNo()
    {
        return $this->ReceiptNo;
    }
    /**
     * Set ReceiptNo value
     * @param int $receiptNo
     * @return \StructType\AttachFileToReceipt
     */
    public function setReceiptNo($receiptNo = null)
    {
        // validation for constraint: int
        if (!is_null($receiptNo) && !(is_int($receiptNo) || ctype_digit($receiptNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($receiptNo, true), gettype($receiptNo)), __LINE__);
        }
        $this->ReceiptNo = $receiptNo;
        return $this;
    }
    /**
     * Get UserName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->UserName;
    }
    /**
     * Set UserName value
     * @param string $userName
     * @return \StructType\AttachFileToReceipt
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userName, true), gettype($userName)), __LINE__);
        }
        $this->UserName = $userName;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\AttachFileToReceipt
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get Base64String value
     * @return string|null
     */
    public function getBase64String()
    {
        return $this->Base64String;
    }
    /**
     * Set Base64String value
     * @param string $base64String
     * @return \StructType\AttachFileToReceipt
     */
    public function setBase64String($base64String = null)
    {
        // validation for constraint: string
        if (!is_null($base64String) && !is_string($base64String)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($base64String, true), gettype($base64String)), __LINE__);
        }
        $this->Base64String = $base64String;
        return $this;
    }
    /**
     * Get ContentType value
     * @return string|null
     */
    public function getContentType()
    {
        return $this->ContentType;
    }
    /**
     * Set ContentType value
     * @param string $contentType
     * @return \StructType\AttachFileToReceipt
     */
    public function setContentType($contentType = null)
    {
        // validation for constraint: string
        if (!is_null($contentType) && !is_string($contentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contentType, true), gettype($contentType)), __LINE__);
        }
        $this->ContentType = $contentType;
        return $this;
    }
    /**
     * Get Filename value
     * @return string|null
     */
    public function getFilename()
    {
        return $this->Filename;
    }
    /**
     * Set Filename value
     * @param string $filename
     * @return \StructType\AttachFileToReceipt
     */
    public function setFilename($filename = null)
    {
        // validation for constraint: string
        if (!is_null($filename) && !is_string($filename)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($filename, true), gettype($filename)), __LINE__);
        }
        $this->Filename = $filename;
        return $this;
    }
    /**
     * Get FileExtension value
     * @return string|null
     */
    public function getFileExtension()
    {
        return $this->FileExtension;
    }
    /**
     * Set FileExtension value
     * @param string $fileExtension
     * @return \StructType\AttachFileToReceipt
     */
    public function setFileExtension($fileExtension = null)
    {
        // validation for constraint: string
        if (!is_null($fileExtension) && !is_string($fileExtension)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileExtension, true), gettype($fileExtension)), __LINE__);
        }
        $this->FileExtension = $fileExtension;
        return $this;
    }
    /**
     * Get FileSize value
     * @return string|null
     */
    public function getFileSize()
    {
        return $this->FileSize;
    }
    /**
     * Set FileSize value
     * @param string $fileSize
     * @return \StructType\AttachFileToReceipt
     */
    public function setFileSize($fileSize = null)
    {
        // validation for constraint: string
        if (!is_null($fileSize) && !is_string($fileSize)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileSize, true), gettype($fileSize)), __LINE__);
        }
        $this->FileSize = $fileSize;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AttachFileToReceipt
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
