<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AllocateAdvancePaymentToInvoice StructType
 * @subpackage Structs
 */
class AllocateAdvancePaymentToInvoice extends AbstractStructBase
{
    /**
     * The InvoiceNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $InvoiceNumber;
    /**
     * The BankTxId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BankTxId;
    /**
     * The UserName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UserName;
    /**
     * The Password
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * Constructor method for AllocateAdvancePaymentToInvoice
     * @uses AllocateAdvancePaymentToInvoice::setInvoiceNumber()
     * @uses AllocateAdvancePaymentToInvoice::setBankTxId()
     * @uses AllocateAdvancePaymentToInvoice::setUserName()
     * @uses AllocateAdvancePaymentToInvoice::setPassword()
     * @param int $invoiceNumber
     * @param int $bankTxId
     * @param string $userName
     * @param string $password
     */
    public function __construct($invoiceNumber = null, $bankTxId = null, $userName = null, $password = null)
    {
        $this
            ->setInvoiceNumber($invoiceNumber)
            ->setBankTxId($bankTxId)
            ->setUserName($userName)
            ->setPassword($password);
    }
    /**
     * Get InvoiceNumber value
     * @return int
     */
    public function getInvoiceNumber()
    {
        return $this->InvoiceNumber;
    }
    /**
     * Set InvoiceNumber value
     * @param int $invoiceNumber
     * @return \StructType\AllocateAdvancePaymentToInvoice
     */
    public function setInvoiceNumber($invoiceNumber = null)
    {
        // validation for constraint: int
        if (!is_null($invoiceNumber) && !(is_int($invoiceNumber) || ctype_digit($invoiceNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($invoiceNumber, true), gettype($invoiceNumber)), __LINE__);
        }
        $this->InvoiceNumber = $invoiceNumber;
        return $this;
    }
    /**
     * Get BankTxId value
     * @return int
     */
    public function getBankTxId()
    {
        return $this->BankTxId;
    }
    /**
     * Set BankTxId value
     * @param int $bankTxId
     * @return \StructType\AllocateAdvancePaymentToInvoice
     */
    public function setBankTxId($bankTxId = null)
    {
        // validation for constraint: int
        if (!is_null($bankTxId) && !(is_int($bankTxId) || ctype_digit($bankTxId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bankTxId, true), gettype($bankTxId)), __LINE__);
        }
        $this->BankTxId = $bankTxId;
        return $this;
    }
    /**
     * Get UserName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->UserName;
    }
    /**
     * Set UserName value
     * @param string $userName
     * @return \StructType\AllocateAdvancePaymentToInvoice
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userName, true), gettype($userName)), __LINE__);
        }
        $this->UserName = $userName;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\AllocateAdvancePaymentToInvoice
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AllocateAdvancePaymentToInvoice
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
