<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for VCFT ServiceType
 * @subpackage Services
 */
class VCFT extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named VCFToCustomerObjects
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\VCFToCustomerObjects $parameters
     * @return \StructType\VCFToCustomerObjectsResponse|bool
     */
    public function VCFToCustomerObjects(\StructType\VCFToCustomerObjects $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->VCFToCustomerObjects($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\VCFToCustomerObjectsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
