<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Set ServiceType
 * @subpackage Services
 */
class Set extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SetCustomerVATNumber
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetCustomerVATNumber $parameters
     * @return \StructType\SetCustomerVATNumberResponse|bool
     */
    public function SetCustomerVATNumber(\StructType\SetCustomerVATNumber $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetCustomerVATNumber($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetCustomerCurrency
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetCustomerCurrency $parameters
     * @return \StructType\SetCustomerCurrencyResponse|bool
     */
    public function SetCustomerCurrency(\StructType\SetCustomerCurrency $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetCustomerCurrency($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetSupplierVATNumber
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetSupplierVATNumber $parameters
     * @return \StructType\SetSupplierVATNumberResponse|bool
     */
    public function SetSupplierVATNumber(\StructType\SetSupplierVATNumber $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetSupplierVATNumber($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetSupplierCurrency
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetSupplierCurrency $parameters
     * @return \StructType\SetSupplierCurrencyResponse|bool
     */
    public function SetSupplierCurrency(\StructType\SetSupplierCurrency $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetSupplierCurrency($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SetCustomerCurrencyResponse|\StructType\SetCustomerVATNumberResponse|\StructType\SetSupplierCurrencyResponse|\StructType\SetSupplierVATNumberResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
