<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Allocate ServiceType
 * @subpackage Services
 */
class Allocate extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named AllocateAdvancePaymentToInvoice
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AllocateAdvancePaymentToInvoice $parameters
     * @return \StructType\AllocateAdvancePaymentToInvoiceResponse|bool
     */
    public function AllocateAdvancePaymentToInvoice(\StructType\AllocateAdvancePaymentToInvoice $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AllocateAdvancePaymentToInvoice($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AllocateAdvancePaymentToReceipt
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AllocateAdvancePaymentToReceipt $parameters
     * @return \StructType\AllocateAdvancePaymentToReceiptResponse|bool
     */
    public function AllocateAdvancePaymentToReceipt(\StructType\AllocateAdvancePaymentToReceipt $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AllocateAdvancePaymentToReceipt($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\AllocateAdvancePaymentToInvoiceResponse|\StructType\AllocateAdvancePaymentToReceiptResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
