<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfTransactionInformation ArrayType
 * @subpackage Arrays
 */
class ArrayOfTransactionInformation extends AbstractStructArrayBase
{
    /**
     * The TransactionInformation
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\TransactionInformation[]
     */
    public $TransactionInformation;
    /**
     * Constructor method for ArrayOfTransactionInformation
     * @uses ArrayOfTransactionInformation::setTransactionInformation()
     * @param \StructType\TransactionInformation[] $transactionInformation
     */
    public function __construct(array $transactionInformation = array())
    {
        $this
            ->setTransactionInformation($transactionInformation);
    }
    /**
     * Get TransactionInformation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\TransactionInformation[]|null
     */
    public function getTransactionInformation()
    {
        return isset($this->TransactionInformation) ? $this->TransactionInformation : null;
    }
    /**
     * This method is responsible for validating the values passed to the setTransactionInformation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTransactionInformation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTransactionInformationForArrayConstraintsFromSetTransactionInformation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfTransactionInformationTransactionInformationItem) {
            // validation for constraint: itemType
            if (!$arrayOfTransactionInformationTransactionInformationItem instanceof \StructType\TransactionInformation) {
                $invalidValues[] = is_object($arrayOfTransactionInformationTransactionInformationItem) ? get_class($arrayOfTransactionInformationTransactionInformationItem) : sprintf('%s(%s)', gettype($arrayOfTransactionInformationTransactionInformationItem), var_export($arrayOfTransactionInformationTransactionInformationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TransactionInformation property can only contain items of type \StructType\TransactionInformation, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TransactionInformation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\TransactionInformation[] $transactionInformation
     * @return \ArrayType\ArrayOfTransactionInformation
     */
    public function setTransactionInformation(array $transactionInformation = array())
    {
        // validation for constraint: array
        if ('' !== ($transactionInformationArrayErrorMessage = self::validateTransactionInformationForArrayConstraintsFromSetTransactionInformation($transactionInformation))) {
            throw new \InvalidArgumentException($transactionInformationArrayErrorMessage, __LINE__);
        }
        if (is_null($transactionInformation) || (is_array($transactionInformation) && empty($transactionInformation))) {
            unset($this->TransactionInformation);
        } else {
            $this->TransactionInformation = $transactionInformation;
        }
        return $this;
    }
    /**
     * Add item to TransactionInformation value
     * @throws \InvalidArgumentException
     * @param \StructType\TransactionInformation $item
     * @return \ArrayType\ArrayOfTransactionInformation
     */
    public function addToTransactionInformation(\StructType\TransactionInformation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TransactionInformation) {
            throw new \InvalidArgumentException(sprintf('The TransactionInformation property can only contain items of type \StructType\TransactionInformation, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TransactionInformation[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\TransactionInformation|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\TransactionInformation|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\TransactionInformation|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\TransactionInformation|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\TransactionInformation|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string TransactionInformation
     */
    public function getAttributeName()
    {
        return 'TransactionInformation';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfTransactionInformation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
