<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPaymentMethod ArrayType
 * @subpackage Arrays
 */
class ArrayOfPaymentMethod extends AbstractStructArrayBase
{
    /**
     * The PaymentMethod
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PaymentMethod[]
     */
    public $PaymentMethod;
    /**
     * Constructor method for ArrayOfPaymentMethod
     * @uses ArrayOfPaymentMethod::setPaymentMethod()
     * @param \StructType\PaymentMethod[] $paymentMethod
     */
    public function __construct(array $paymentMethod = array())
    {
        $this
            ->setPaymentMethod($paymentMethod);
    }
    /**
     * Get PaymentMethod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PaymentMethod[]|null
     */
    public function getPaymentMethod()
    {
        return isset($this->PaymentMethod) ? $this->PaymentMethod : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPaymentMethod method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaymentMethod method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaymentMethodForArrayConstraintsFromSetPaymentMethod(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfPaymentMethodPaymentMethodItem) {
            // validation for constraint: itemType
            if (!$arrayOfPaymentMethodPaymentMethodItem instanceof \StructType\PaymentMethod) {
                $invalidValues[] = is_object($arrayOfPaymentMethodPaymentMethodItem) ? get_class($arrayOfPaymentMethodPaymentMethodItem) : sprintf('%s(%s)', gettype($arrayOfPaymentMethodPaymentMethodItem), var_export($arrayOfPaymentMethodPaymentMethodItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaymentMethod property can only contain items of type \StructType\PaymentMethod, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaymentMethod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentMethod[] $paymentMethod
     * @return \ArrayType\ArrayOfPaymentMethod
     */
    public function setPaymentMethod(array $paymentMethod = array())
    {
        // validation for constraint: array
        if ('' !== ($paymentMethodArrayErrorMessage = self::validatePaymentMethodForArrayConstraintsFromSetPaymentMethod($paymentMethod))) {
            throw new \InvalidArgumentException($paymentMethodArrayErrorMessage, __LINE__);
        }
        if (is_null($paymentMethod) || (is_array($paymentMethod) && empty($paymentMethod))) {
            unset($this->PaymentMethod);
        } else {
            $this->PaymentMethod = $paymentMethod;
        }
        return $this;
    }
    /**
     * Add item to PaymentMethod value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentMethod $item
     * @return \ArrayType\ArrayOfPaymentMethod
     */
    public function addToPaymentMethod(\StructType\PaymentMethod $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PaymentMethod) {
            throw new \InvalidArgumentException(sprintf('The PaymentMethod property can only contain items of type \StructType\PaymentMethod, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PaymentMethod[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\PaymentMethod|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\PaymentMethod|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\PaymentMethod|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\PaymentMethod|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\PaymentMethod|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PaymentMethod
     */
    public function getAttributeName()
    {
        return 'PaymentMethod';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfPaymentMethod
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
