<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfInvoiceLine ArrayType
 * @subpackage Arrays
 */
class ArrayOfInvoiceLine extends AbstractStructArrayBase
{
    /**
     * The InvoiceLine
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\InvoiceLine[]
     */
    public $InvoiceLine;
    /**
     * Constructor method for ArrayOfInvoiceLine
     * @uses ArrayOfInvoiceLine::setInvoiceLine()
     * @param \StructType\InvoiceLine[] $invoiceLine
     */
    public function __construct(array $invoiceLine = array())
    {
        $this
            ->setInvoiceLine($invoiceLine);
    }
    /**
     * Get InvoiceLine value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\InvoiceLine[]|null
     */
    public function getInvoiceLine()
    {
        return isset($this->InvoiceLine) ? $this->InvoiceLine : null;
    }
    /**
     * This method is responsible for validating the values passed to the setInvoiceLine method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInvoiceLine method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInvoiceLineForArrayConstraintsFromSetInvoiceLine(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfInvoiceLineInvoiceLineItem) {
            // validation for constraint: itemType
            if (!$arrayOfInvoiceLineInvoiceLineItem instanceof \StructType\InvoiceLine) {
                $invalidValues[] = is_object($arrayOfInvoiceLineInvoiceLineItem) ? get_class($arrayOfInvoiceLineInvoiceLineItem) : sprintf('%s(%s)', gettype($arrayOfInvoiceLineInvoiceLineItem), var_export($arrayOfInvoiceLineInvoiceLineItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The InvoiceLine property can only contain items of type \StructType\InvoiceLine, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set InvoiceLine value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\InvoiceLine[] $invoiceLine
     * @return \ArrayType\ArrayOfInvoiceLine
     */
    public function setInvoiceLine(array $invoiceLine = array())
    {
        // validation for constraint: array
        if ('' !== ($invoiceLineArrayErrorMessage = self::validateInvoiceLineForArrayConstraintsFromSetInvoiceLine($invoiceLine))) {
            throw new \InvalidArgumentException($invoiceLineArrayErrorMessage, __LINE__);
        }
        if (is_null($invoiceLine) || (is_array($invoiceLine) && empty($invoiceLine))) {
            unset($this->InvoiceLine);
        } else {
            $this->InvoiceLine = $invoiceLine;
        }
        return $this;
    }
    /**
     * Add item to InvoiceLine value
     * @throws \InvalidArgumentException
     * @param \StructType\InvoiceLine $item
     * @return \ArrayType\ArrayOfInvoiceLine
     */
    public function addToInvoiceLine(\StructType\InvoiceLine $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\InvoiceLine) {
            throw new \InvalidArgumentException(sprintf('The InvoiceLine property can only contain items of type \StructType\InvoiceLine, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->InvoiceLine[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\InvoiceLine|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\InvoiceLine|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\InvoiceLine|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\InvoiceLine|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\InvoiceLine|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string InvoiceLine
     */
    public function getAttributeName()
    {
        return 'InvoiceLine';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfInvoiceLine
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
