<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfBankTXType ArrayType
 * @subpackage Arrays
 */
class ArrayOfBankTXType extends AbstractStructArrayBase
{
    /**
     * The BankTXType
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BankTXType[]
     */
    public $BankTXType;
    /**
     * Constructor method for ArrayOfBankTXType
     * @uses ArrayOfBankTXType::setBankTXType()
     * @param \StructType\BankTXType[] $bankTXType
     */
    public function __construct(array $bankTXType = array())
    {
        $this
            ->setBankTXType($bankTXType);
    }
    /**
     * Get BankTXType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BankTXType[]|null
     */
    public function getBankTXType()
    {
        return isset($this->BankTXType) ? $this->BankTXType : null;
    }
    /**
     * This method is responsible for validating the values passed to the setBankTXType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBankTXType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBankTXTypeForArrayConstraintsFromSetBankTXType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfBankTXTypeBankTXTypeItem) {
            // validation for constraint: itemType
            if (!$arrayOfBankTXTypeBankTXTypeItem instanceof \StructType\BankTXType) {
                $invalidValues[] = is_object($arrayOfBankTXTypeBankTXTypeItem) ? get_class($arrayOfBankTXTypeBankTXTypeItem) : sprintf('%s(%s)', gettype($arrayOfBankTXTypeBankTXTypeItem), var_export($arrayOfBankTXTypeBankTXTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BankTXType property can only contain items of type \StructType\BankTXType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BankTXType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\BankTXType[] $bankTXType
     * @return \ArrayType\ArrayOfBankTXType
     */
    public function setBankTXType(array $bankTXType = array())
    {
        // validation for constraint: array
        if ('' !== ($bankTXTypeArrayErrorMessage = self::validateBankTXTypeForArrayConstraintsFromSetBankTXType($bankTXType))) {
            throw new \InvalidArgumentException($bankTXTypeArrayErrorMessage, __LINE__);
        }
        if (is_null($bankTXType) || (is_array($bankTXType) && empty($bankTXType))) {
            unset($this->BankTXType);
        } else {
            $this->BankTXType = $bankTXType;
        }
        return $this;
    }
    /**
     * Add item to BankTXType value
     * @throws \InvalidArgumentException
     * @param \StructType\BankTXType $item
     * @return \ArrayType\ArrayOfBankTXType
     */
    public function addToBankTXType(\StructType\BankTXType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BankTXType) {
            throw new \InvalidArgumentException(sprintf('The BankTXType property can only contain items of type \StructType\BankTXType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->BankTXType[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\BankTXType|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\BankTXType|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\BankTXType|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\BankTXType|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\BankTXType|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string BankTXType
     */
    public function getAttributeName()
    {
        return 'BankTXType';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfBankTXType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
