<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VCFToCustomerObjects StructType
 * @subpackage Structs
 */
class VCFToCustomerObjects extends AbstractStructBase
{
    /**
     * The UserName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UserName;
    /**
     * The Password
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * The inStream
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $inStream;
    /**
     * Constructor method for VCFToCustomerObjects
     * @uses VCFToCustomerObjects::setUserName()
     * @uses VCFToCustomerObjects::setPassword()
     * @uses VCFToCustomerObjects::setInStream()
     * @param string $userName
     * @param string $password
     * @param string $inStream
     */
    public function __construct($userName = null, $password = null, $inStream = null)
    {
        $this
            ->setUserName($userName)
            ->setPassword($password)
            ->setInStream($inStream);
    }
    /**
     * Get UserName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->UserName;
    }
    /**
     * Set UserName value
     * @param string $userName
     * @return \StructType\VCFToCustomerObjects
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userName, true), gettype($userName)), __LINE__);
        }
        $this->UserName = $userName;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\VCFToCustomerObjects
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get inStream value
     * @return string|null
     */
    public function getInStream()
    {
        return $this->inStream;
    }
    /**
     * Set inStream value
     * @param string $inStream
     * @return \StructType\VCFToCustomerObjects
     */
    public function setInStream($inStream = null)
    {
        // validation for constraint: string
        if (!is_null($inStream) && !is_string($inStream)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inStream, true), gettype($inStream)), __LINE__);
        }
        $this->inStream = $inStream;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VCFToCustomerObjects
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
