<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReceiptAttachment StructType
 * @subpackage Structs
 */
class ReceiptAttachment extends AbstractStructBase
{
    /**
     * The AttachmentID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AttachmentID;
    /**
     * The ReceiptID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ReceiptID;
    /**
     * The UploadDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $UploadDate;
    /**
     * The ActualFilename
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ActualFilename;
    /**
     * The AmazonFilename
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AmazonFilename;
    /**
     * The ContentType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ContentType;
    /**
     * The MetaName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MetaName;
    /**
     * The MetaValue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MetaValue;
    /**
     * The FileSize
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FileSize;
    /**
     * The FileExtension
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FileExtension;
    /**
     * The FileURL
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FileURL;
    /**
     * Constructor method for ReceiptAttachment
     * @uses ReceiptAttachment::setAttachmentID()
     * @uses ReceiptAttachment::setReceiptID()
     * @uses ReceiptAttachment::setUploadDate()
     * @uses ReceiptAttachment::setActualFilename()
     * @uses ReceiptAttachment::setAmazonFilename()
     * @uses ReceiptAttachment::setContentType()
     * @uses ReceiptAttachment::setMetaName()
     * @uses ReceiptAttachment::setMetaValue()
     * @uses ReceiptAttachment::setFileSize()
     * @uses ReceiptAttachment::setFileExtension()
     * @uses ReceiptAttachment::setFileURL()
     * @param int $attachmentID
     * @param int $receiptID
     * @param string $uploadDate
     * @param string $actualFilename
     * @param string $amazonFilename
     * @param string $contentType
     * @param string $metaName
     * @param string $metaValue
     * @param string $fileSize
     * @param string $fileExtension
     * @param string $fileURL
     */
    public function __construct($attachmentID = null, $receiptID = null, $uploadDate = null, $actualFilename = null, $amazonFilename = null, $contentType = null, $metaName = null, $metaValue = null, $fileSize = null, $fileExtension = null, $fileURL = null)
    {
        $this
            ->setAttachmentID($attachmentID)
            ->setReceiptID($receiptID)
            ->setUploadDate($uploadDate)
            ->setActualFilename($actualFilename)
            ->setAmazonFilename($amazonFilename)
            ->setContentType($contentType)
            ->setMetaName($metaName)
            ->setMetaValue($metaValue)
            ->setFileSize($fileSize)
            ->setFileExtension($fileExtension)
            ->setFileURL($fileURL);
    }
    /**
     * Get AttachmentID value
     * @return int
     */
    public function getAttachmentID()
    {
        return $this->AttachmentID;
    }
    /**
     * Set AttachmentID value
     * @param int $attachmentID
     * @return \StructType\ReceiptAttachment
     */
    public function setAttachmentID($attachmentID = null)
    {
        // validation for constraint: int
        if (!is_null($attachmentID) && !(is_int($attachmentID) || ctype_digit($attachmentID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($attachmentID, true), gettype($attachmentID)), __LINE__);
        }
        $this->AttachmentID = $attachmentID;
        return $this;
    }
    /**
     * Get ReceiptID value
     * @return int
     */
    public function getReceiptID()
    {
        return $this->ReceiptID;
    }
    /**
     * Set ReceiptID value
     * @param int $receiptID
     * @return \StructType\ReceiptAttachment
     */
    public function setReceiptID($receiptID = null)
    {
        // validation for constraint: int
        if (!is_null($receiptID) && !(is_int($receiptID) || ctype_digit($receiptID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($receiptID, true), gettype($receiptID)), __LINE__);
        }
        $this->ReceiptID = $receiptID;
        return $this;
    }
    /**
     * Get UploadDate value
     * @return string
     */
    public function getUploadDate()
    {
        return $this->UploadDate;
    }
    /**
     * Set UploadDate value
     * @param string $uploadDate
     * @return \StructType\ReceiptAttachment
     */
    public function setUploadDate($uploadDate = null)
    {
        // validation for constraint: string
        if (!is_null($uploadDate) && !is_string($uploadDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uploadDate, true), gettype($uploadDate)), __LINE__);
        }
        $this->UploadDate = $uploadDate;
        return $this;
    }
    /**
     * Get ActualFilename value
     * @return string|null
     */
    public function getActualFilename()
    {
        return $this->ActualFilename;
    }
    /**
     * Set ActualFilename value
     * @param string $actualFilename
     * @return \StructType\ReceiptAttachment
     */
    public function setActualFilename($actualFilename = null)
    {
        // validation for constraint: string
        if (!is_null($actualFilename) && !is_string($actualFilename)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($actualFilename, true), gettype($actualFilename)), __LINE__);
        }
        $this->ActualFilename = $actualFilename;
        return $this;
    }
    /**
     * Get AmazonFilename value
     * @return string|null
     */
    public function getAmazonFilename()
    {
        return $this->AmazonFilename;
    }
    /**
     * Set AmazonFilename value
     * @param string $amazonFilename
     * @return \StructType\ReceiptAttachment
     */
    public function setAmazonFilename($amazonFilename = null)
    {
        // validation for constraint: string
        if (!is_null($amazonFilename) && !is_string($amazonFilename)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amazonFilename, true), gettype($amazonFilename)), __LINE__);
        }
        $this->AmazonFilename = $amazonFilename;
        return $this;
    }
    /**
     * Get ContentType value
     * @return string|null
     */
    public function getContentType()
    {
        return $this->ContentType;
    }
    /**
     * Set ContentType value
     * @param string $contentType
     * @return \StructType\ReceiptAttachment
     */
    public function setContentType($contentType = null)
    {
        // validation for constraint: string
        if (!is_null($contentType) && !is_string($contentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contentType, true), gettype($contentType)), __LINE__);
        }
        $this->ContentType = $contentType;
        return $this;
    }
    /**
     * Get MetaName value
     * @return string|null
     */
    public function getMetaName()
    {
        return $this->MetaName;
    }
    /**
     * Set MetaName value
     * @param string $metaName
     * @return \StructType\ReceiptAttachment
     */
    public function setMetaName($metaName = null)
    {
        // validation for constraint: string
        if (!is_null($metaName) && !is_string($metaName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($metaName, true), gettype($metaName)), __LINE__);
        }
        $this->MetaName = $metaName;
        return $this;
    }
    /**
     * Get MetaValue value
     * @return string|null
     */
    public function getMetaValue()
    {
        return $this->MetaValue;
    }
    /**
     * Set MetaValue value
     * @param string $metaValue
     * @return \StructType\ReceiptAttachment
     */
    public function setMetaValue($metaValue = null)
    {
        // validation for constraint: string
        if (!is_null($metaValue) && !is_string($metaValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($metaValue, true), gettype($metaValue)), __LINE__);
        }
        $this->MetaValue = $metaValue;
        return $this;
    }
    /**
     * Get FileSize value
     * @return string|null
     */
    public function getFileSize()
    {
        return $this->FileSize;
    }
    /**
     * Set FileSize value
     * @param string $fileSize
     * @return \StructType\ReceiptAttachment
     */
    public function setFileSize($fileSize = null)
    {
        // validation for constraint: string
        if (!is_null($fileSize) && !is_string($fileSize)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileSize, true), gettype($fileSize)), __LINE__);
        }
        $this->FileSize = $fileSize;
        return $this;
    }
    /**
     * Get FileExtension value
     * @return string|null
     */
    public function getFileExtension()
    {
        return $this->FileExtension;
    }
    /**
     * Set FileExtension value
     * @param string $fileExtension
     * @return \StructType\ReceiptAttachment
     */
    public function setFileExtension($fileExtension = null)
    {
        // validation for constraint: string
        if (!is_null($fileExtension) && !is_string($fileExtension)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileExtension, true), gettype($fileExtension)), __LINE__);
        }
        $this->FileExtension = $fileExtension;
        return $this;
    }
    /**
     * Get FileURL value
     * @return string|null
     */
    public function getFileURL()
    {
        return $this->FileURL;
    }
    /**
     * Set FileURL value
     * @param string $fileURL
     * @return \StructType\ReceiptAttachment
     */
    public function setFileURL($fileURL = null)
    {
        // validation for constraint: string
        if (!is_null($fileURL) && !is_string($fileURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileURL, true), gettype($fileURL)), __LINE__);
        }
        $this->FileURL = $fileURL;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ReceiptAttachment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
