<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProfitAndLoss StructType
 * @subpackage Structs
 */
class ProfitAndLoss extends AbstractStructBase
{
    /**
     * The StartDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $StartDate;
    /**
     * The EndDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $EndDate;
    /**
     * The TurnoverTotal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TurnoverTotal;
    /**
     * The CostOfSalesTotal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $CostOfSalesTotal;
    /**
     * The GrossProfit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $GrossProfit;
    /**
     * The ExpensesTotal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ExpensesTotal;
    /**
     * The NetProfit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $NetProfit;
    /**
     * The Turnover
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfAnyType
     */
    public $Turnover;
    /**
     * The CostOfSales
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfAnyType
     */
    public $CostOfSales;
    /**
     * The Expenses
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfAnyType
     */
    public $Expenses;
    /**
     * Constructor method for ProfitAndLoss
     * @uses ProfitAndLoss::setStartDate()
     * @uses ProfitAndLoss::setEndDate()
     * @uses ProfitAndLoss::setTurnoverTotal()
     * @uses ProfitAndLoss::setCostOfSalesTotal()
     * @uses ProfitAndLoss::setGrossProfit()
     * @uses ProfitAndLoss::setExpensesTotal()
     * @uses ProfitAndLoss::setNetProfit()
     * @uses ProfitAndLoss::setTurnover()
     * @uses ProfitAndLoss::setCostOfSales()
     * @uses ProfitAndLoss::setExpenses()
     * @param string $startDate
     * @param string $endDate
     * @param float $turnoverTotal
     * @param float $costOfSalesTotal
     * @param float $grossProfit
     * @param float $expensesTotal
     * @param float $netProfit
     * @param \ArrayType\ArrayOfAnyType $turnover
     * @param \ArrayType\ArrayOfAnyType $costOfSales
     * @param \ArrayType\ArrayOfAnyType $expenses
     */
    public function __construct($startDate = null, $endDate = null, $turnoverTotal = null, $costOfSalesTotal = null, $grossProfit = null, $expensesTotal = null, $netProfit = null, \ArrayType\ArrayOfAnyType $turnover = null, \ArrayType\ArrayOfAnyType $costOfSales = null, \ArrayType\ArrayOfAnyType $expenses = null)
    {
        $this
            ->setStartDate($startDate)
            ->setEndDate($endDate)
            ->setTurnoverTotal($turnoverTotal)
            ->setCostOfSalesTotal($costOfSalesTotal)
            ->setGrossProfit($grossProfit)
            ->setExpensesTotal($expensesTotal)
            ->setNetProfit($netProfit)
            ->setTurnover($turnover)
            ->setCostOfSales($costOfSales)
            ->setExpenses($expenses);
    }
    /**
     * Get StartDate value
     * @return string
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }
    /**
     * Set StartDate value
     * @param string $startDate
     * @return \StructType\ProfitAndLoss
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        $this->StartDate = $startDate;
        return $this;
    }
    /**
     * Get EndDate value
     * @return string
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }
    /**
     * Set EndDate value
     * @param string $endDate
     * @return \StructType\ProfitAndLoss
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        $this->EndDate = $endDate;
        return $this;
    }
    /**
     * Get TurnoverTotal value
     * @return float
     */
    public function getTurnoverTotal()
    {
        return $this->TurnoverTotal;
    }
    /**
     * Set TurnoverTotal value
     * @param float $turnoverTotal
     * @return \StructType\ProfitAndLoss
     */
    public function setTurnoverTotal($turnoverTotal = null)
    {
        // validation for constraint: float
        if (!is_null($turnoverTotal) && !(is_float($turnoverTotal) || is_numeric($turnoverTotal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($turnoverTotal, true), gettype($turnoverTotal)), __LINE__);
        }
        $this->TurnoverTotal = $turnoverTotal;
        return $this;
    }
    /**
     * Get CostOfSalesTotal value
     * @return float
     */
    public function getCostOfSalesTotal()
    {
        return $this->CostOfSalesTotal;
    }
    /**
     * Set CostOfSalesTotal value
     * @param float $costOfSalesTotal
     * @return \StructType\ProfitAndLoss
     */
    public function setCostOfSalesTotal($costOfSalesTotal = null)
    {
        // validation for constraint: float
        if (!is_null($costOfSalesTotal) && !(is_float($costOfSalesTotal) || is_numeric($costOfSalesTotal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($costOfSalesTotal, true), gettype($costOfSalesTotal)), __LINE__);
        }
        $this->CostOfSalesTotal = $costOfSalesTotal;
        return $this;
    }
    /**
     * Get GrossProfit value
     * @return float
     */
    public function getGrossProfit()
    {
        return $this->GrossProfit;
    }
    /**
     * Set GrossProfit value
     * @param float $grossProfit
     * @return \StructType\ProfitAndLoss
     */
    public function setGrossProfit($grossProfit = null)
    {
        // validation for constraint: float
        if (!is_null($grossProfit) && !(is_float($grossProfit) || is_numeric($grossProfit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($grossProfit, true), gettype($grossProfit)), __LINE__);
        }
        $this->GrossProfit = $grossProfit;
        return $this;
    }
    /**
     * Get ExpensesTotal value
     * @return float
     */
    public function getExpensesTotal()
    {
        return $this->ExpensesTotal;
    }
    /**
     * Set ExpensesTotal value
     * @param float $expensesTotal
     * @return \StructType\ProfitAndLoss
     */
    public function setExpensesTotal($expensesTotal = null)
    {
        // validation for constraint: float
        if (!is_null($expensesTotal) && !(is_float($expensesTotal) || is_numeric($expensesTotal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($expensesTotal, true), gettype($expensesTotal)), __LINE__);
        }
        $this->ExpensesTotal = $expensesTotal;
        return $this;
    }
    /**
     * Get NetProfit value
     * @return float
     */
    public function getNetProfit()
    {
        return $this->NetProfit;
    }
    /**
     * Set NetProfit value
     * @param float $netProfit
     * @return \StructType\ProfitAndLoss
     */
    public function setNetProfit($netProfit = null)
    {
        // validation for constraint: float
        if (!is_null($netProfit) && !(is_float($netProfit) || is_numeric($netProfit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($netProfit, true), gettype($netProfit)), __LINE__);
        }
        $this->NetProfit = $netProfit;
        return $this;
    }
    /**
     * Get Turnover value
     * @return \ArrayType\ArrayOfAnyType|null
     */
    public function getTurnover()
    {
        return $this->Turnover;
    }
    /**
     * Set Turnover value
     * @param \ArrayType\ArrayOfAnyType $turnover
     * @return \StructType\ProfitAndLoss
     */
    public function setTurnover(\ArrayType\ArrayOfAnyType $turnover = null)
    {
        $this->Turnover = $turnover;
        return $this;
    }
    /**
     * Get CostOfSales value
     * @return \ArrayType\ArrayOfAnyType|null
     */
    public function getCostOfSales()
    {
        return $this->CostOfSales;
    }
    /**
     * Set CostOfSales value
     * @param \ArrayType\ArrayOfAnyType $costOfSales
     * @return \StructType\ProfitAndLoss
     */
    public function setCostOfSales(\ArrayType\ArrayOfAnyType $costOfSales = null)
    {
        $this->CostOfSales = $costOfSales;
        return $this;
    }
    /**
     * Get Expenses value
     * @return \ArrayType\ArrayOfAnyType|null
     */
    public function getExpenses()
    {
        return $this->Expenses;
    }
    /**
     * Set Expenses value
     * @param \ArrayType\ArrayOfAnyType $expenses
     * @return \StructType\ProfitAndLoss
     */
    public function setExpenses(\ArrayType\ArrayOfAnyType $expenses = null)
    {
        $this->Expenses = $expenses;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProfitAndLoss
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
