<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentMethod StructType
 * @subpackage Structs
 */
class PaymentMethod extends AbstractStructBase
{
    /**
     * The MethodID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MethodID;
    /**
     * The MethodName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MethodName;
    /**
     * Constructor method for PaymentMethod
     * @uses PaymentMethod::setMethodID()
     * @uses PaymentMethod::setMethodName()
     * @param int $methodID
     * @param string $methodName
     */
    public function __construct($methodID = null, $methodName = null)
    {
        $this
            ->setMethodID($methodID)
            ->setMethodName($methodName);
    }
    /**
     * Get MethodID value
     * @return int
     */
    public function getMethodID()
    {
        return $this->MethodID;
    }
    /**
     * Set MethodID value
     * @param int $methodID
     * @return \StructType\PaymentMethod
     */
    public function setMethodID($methodID = null)
    {
        // validation for constraint: int
        if (!is_null($methodID) && !(is_int($methodID) || ctype_digit($methodID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($methodID, true), gettype($methodID)), __LINE__);
        }
        $this->MethodID = $methodID;
        return $this;
    }
    /**
     * Get MethodName value
     * @return string|null
     */
    public function getMethodName()
    {
        return $this->MethodName;
    }
    /**
     * Set MethodName value
     * @param string $methodName
     * @return \StructType\PaymentMethod
     */
    public function setMethodName($methodName = null)
    {
        // validation for constraint: string
        if (!is_null($methodName) && !is_string($methodName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($methodName, true), gettype($methodName)), __LINE__);
        }
        $this->MethodName = $methodName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PaymentMethod
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
