<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NominalCodeBalance StructType
 * @subpackage Structs
 */
class NominalCodeBalance extends NominalCode
{
    /**
     * The OpeningBalance
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $OpeningBalance;
    /**
     * Constructor method for NominalCodeBalance
     * @uses NominalCodeBalance::setOpeningBalance()
     * @param float $openingBalance
     */
    public function __construct($openingBalance = null)
    {
        $this
            ->setOpeningBalance($openingBalance);
    }
    /**
     * Get OpeningBalance value
     * @return float
     */
    public function getOpeningBalance()
    {
        return $this->OpeningBalance;
    }
    /**
     * Set OpeningBalance value
     * @param float $openingBalance
     * @return \StructType\NominalCodeBalance
     */
    public function setOpeningBalance($openingBalance = null)
    {
        // validation for constraint: float
        if (!is_null($openingBalance) && !(is_float($openingBalance) || is_numeric($openingBalance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($openingBalance, true), gettype($openingBalance)), __LINE__);
        }
        $this->OpeningBalance = $openingBalance;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\NominalCodeBalance
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
