<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MonthlyPL StructType
 * @subpackage Structs
 */
class MonthlyPL extends AbstractStructBase
{
    /**
     * The PeriodStart
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PeriodStart;
    /**
     * The PeriodEnd
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PeriodEnd;
    /**
     * The Turnover
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Turnover;
    /**
     * The GrossProfit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $GrossProfit;
    /**
     * The NetProfit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $NetProfit;
    /**
     * Constructor method for MonthlyPL
     * @uses MonthlyPL::setPeriodStart()
     * @uses MonthlyPL::setPeriodEnd()
     * @uses MonthlyPL::setTurnover()
     * @uses MonthlyPL::setGrossProfit()
     * @uses MonthlyPL::setNetProfit()
     * @param string $periodStart
     * @param string $periodEnd
     * @param float $turnover
     * @param float $grossProfit
     * @param float $netProfit
     */
    public function __construct($periodStart = null, $periodEnd = null, $turnover = null, $grossProfit = null, $netProfit = null)
    {
        $this
            ->setPeriodStart($periodStart)
            ->setPeriodEnd($periodEnd)
            ->setTurnover($turnover)
            ->setGrossProfit($grossProfit)
            ->setNetProfit($netProfit);
    }
    /**
     * Get PeriodStart value
     * @return string
     */
    public function getPeriodStart()
    {
        return $this->PeriodStart;
    }
    /**
     * Set PeriodStart value
     * @param string $periodStart
     * @return \StructType\MonthlyPL
     */
    public function setPeriodStart($periodStart = null)
    {
        // validation for constraint: string
        if (!is_null($periodStart) && !is_string($periodStart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($periodStart, true), gettype($periodStart)), __LINE__);
        }
        $this->PeriodStart = $periodStart;
        return $this;
    }
    /**
     * Get PeriodEnd value
     * @return string
     */
    public function getPeriodEnd()
    {
        return $this->PeriodEnd;
    }
    /**
     * Set PeriodEnd value
     * @param string $periodEnd
     * @return \StructType\MonthlyPL
     */
    public function setPeriodEnd($periodEnd = null)
    {
        // validation for constraint: string
        if (!is_null($periodEnd) && !is_string($periodEnd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($periodEnd, true), gettype($periodEnd)), __LINE__);
        }
        $this->PeriodEnd = $periodEnd;
        return $this;
    }
    /**
     * Get Turnover value
     * @return float
     */
    public function getTurnover()
    {
        return $this->Turnover;
    }
    /**
     * Set Turnover value
     * @param float $turnover
     * @return \StructType\MonthlyPL
     */
    public function setTurnover($turnover = null)
    {
        // validation for constraint: float
        if (!is_null($turnover) && !(is_float($turnover) || is_numeric($turnover))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($turnover, true), gettype($turnover)), __LINE__);
        }
        $this->Turnover = $turnover;
        return $this;
    }
    /**
     * Get GrossProfit value
     * @return float
     */
    public function getGrossProfit()
    {
        return $this->GrossProfit;
    }
    /**
     * Set GrossProfit value
     * @param float $grossProfit
     * @return \StructType\MonthlyPL
     */
    public function setGrossProfit($grossProfit = null)
    {
        // validation for constraint: float
        if (!is_null($grossProfit) && !(is_float($grossProfit) || is_numeric($grossProfit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($grossProfit, true), gettype($grossProfit)), __LINE__);
        }
        $this->GrossProfit = $grossProfit;
        return $this;
    }
    /**
     * Get NetProfit value
     * @return float
     */
    public function getNetProfit()
    {
        return $this->NetProfit;
    }
    /**
     * Set NetProfit value
     * @param float $netProfit
     * @return \StructType\MonthlyPL
     */
    public function setNetProfit($netProfit = null)
    {
        // validation for constraint: float
        if (!is_null($netProfit) && !(is_float($netProfit) || is_numeric($netProfit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($netProfit, true), gettype($netProfit)), __LINE__);
        }
        $this->NetProfit = $netProfit;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MonthlyPL
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
