<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JournalEntry StructType
 * @subpackage Structs
 */
class JournalEntry extends AbstractStructBase
{
    /**
     * The DBID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DBID;
    /**
     * The JournalNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $JournalNumber;
    /**
     * The JournalDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $JournalDate;
    /**
     * The Comment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Comment;
    /**
     * The Lines
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfAnyType
     */
    public $Lines;
    /**
     * Constructor method for JournalEntry
     * @uses JournalEntry::setDBID()
     * @uses JournalEntry::setJournalNumber()
     * @uses JournalEntry::setJournalDate()
     * @uses JournalEntry::setComment()
     * @uses JournalEntry::setLines()
     * @param int $dBID
     * @param int $journalNumber
     * @param string $journalDate
     * @param string $comment
     * @param \ArrayType\ArrayOfAnyType $lines
     */
    public function __construct($dBID = null, $journalNumber = null, $journalDate = null, $comment = null, \ArrayType\ArrayOfAnyType $lines = null)
    {
        $this
            ->setDBID($dBID)
            ->setJournalNumber($journalNumber)
            ->setJournalDate($journalDate)
            ->setComment($comment)
            ->setLines($lines);
    }
    /**
     * Get DBID value
     * @return int
     */
    public function getDBID()
    {
        return $this->DBID;
    }
    /**
     * Set DBID value
     * @param int $dBID
     * @return \StructType\JournalEntry
     */
    public function setDBID($dBID = null)
    {
        // validation for constraint: int
        if (!is_null($dBID) && !(is_int($dBID) || ctype_digit($dBID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dBID, true), gettype($dBID)), __LINE__);
        }
        $this->DBID = $dBID;
        return $this;
    }
    /**
     * Get JournalNumber value
     * @return int
     */
    public function getJournalNumber()
    {
        return $this->JournalNumber;
    }
    /**
     * Set JournalNumber value
     * @param int $journalNumber
     * @return \StructType\JournalEntry
     */
    public function setJournalNumber($journalNumber = null)
    {
        // validation for constraint: int
        if (!is_null($journalNumber) && !(is_int($journalNumber) || ctype_digit($journalNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($journalNumber, true), gettype($journalNumber)), __LINE__);
        }
        $this->JournalNumber = $journalNumber;
        return $this;
    }
    /**
     * Get JournalDate value
     * @return string
     */
    public function getJournalDate()
    {
        return $this->JournalDate;
    }
    /**
     * Set JournalDate value
     * @param string $journalDate
     * @return \StructType\JournalEntry
     */
    public function setJournalDate($journalDate = null)
    {
        // validation for constraint: string
        if (!is_null($journalDate) && !is_string($journalDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($journalDate, true), gettype($journalDate)), __LINE__);
        }
        $this->JournalDate = $journalDate;
        return $this;
    }
    /**
     * Get Comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->Comment;
    }
    /**
     * Set Comment value
     * @param string $comment
     * @return \StructType\JournalEntry
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comment, true), gettype($comment)), __LINE__);
        }
        $this->Comment = $comment;
        return $this;
    }
    /**
     * Get Lines value
     * @return \ArrayType\ArrayOfAnyType|null
     */
    public function getLines()
    {
        return $this->Lines;
    }
    /**
     * Set Lines value
     * @param \ArrayType\ArrayOfAnyType $lines
     * @return \StructType\JournalEntry
     */
    public function setLines(\ArrayType\ArrayOfAnyType $lines = null)
    {
        $this->Lines = $lines;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JournalEntry
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
