<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InsertNominalCode StructType
 * @subpackage Structs
 */
class InsertNominalCode extends AbstractStructBase
{
    /**
     * The code
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $code;
    /**
     * The classification
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $classification;
    /**
     * The nomtype
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $nomtype;
    /**
     * The UserName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UserName;
    /**
     * The Password
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * Constructor method for InsertNominalCode
     * @uses InsertNominalCode::setCode()
     * @uses InsertNominalCode::setClassification()
     * @uses InsertNominalCode::setNomtype()
     * @uses InsertNominalCode::setUserName()
     * @uses InsertNominalCode::setPassword()
     * @uses InsertNominalCode::setName()
     * @param int $code
     * @param int $classification
     * @param int $nomtype
     * @param string $userName
     * @param string $password
     * @param string $name
     */
    public function __construct($code = null, $classification = null, $nomtype = null, $userName = null, $password = null, $name = null)
    {
        $this
            ->setCode($code)
            ->setClassification($classification)
            ->setNomtype($nomtype)
            ->setUserName($userName)
            ->setPassword($password)
            ->setName($name);
    }
    /**
     * Get code value
     * @return int
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @param int $code
     * @return \StructType\InsertNominalCode
     */
    public function setCode($code = null)
    {
        // validation for constraint: int
        if (!is_null($code) && !(is_int($code) || ctype_digit($code))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->code = $code;
        return $this;
    }
    /**
     * Get classification value
     * @return int
     */
    public function getClassification()
    {
        return $this->classification;
    }
    /**
     * Set classification value
     * @param int $classification
     * @return \StructType\InsertNominalCode
     */
    public function setClassification($classification = null)
    {
        // validation for constraint: int
        if (!is_null($classification) && !(is_int($classification) || ctype_digit($classification))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($classification, true), gettype($classification)), __LINE__);
        }
        $this->classification = $classification;
        return $this;
    }
    /**
     * Get nomtype value
     * @return int
     */
    public function getNomtype()
    {
        return $this->nomtype;
    }
    /**
     * Set nomtype value
     * @param int $nomtype
     * @return \StructType\InsertNominalCode
     */
    public function setNomtype($nomtype = null)
    {
        // validation for constraint: int
        if (!is_null($nomtype) && !(is_int($nomtype) || ctype_digit($nomtype))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nomtype, true), gettype($nomtype)), __LINE__);
        }
        $this->nomtype = $nomtype;
        return $this;
    }
    /**
     * Get UserName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->UserName;
    }
    /**
     * Set UserName value
     * @param string $userName
     * @return \StructType\InsertNominalCode
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userName, true), gettype($userName)), __LINE__);
        }
        $this->UserName = $userName;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\InsertNominalCode
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\InsertNominalCode
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InsertNominalCode
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
