<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InsertInvoiceNote StructType
 * @subpackage Structs
 */
class InsertInvoiceNote extends AbstractStructBase
{
    /**
     * The InvoiceId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $InvoiceId;
    /**
     * The NoteDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $NoteDate;
    /**
     * The UserName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UserName;
    /**
     * The Password
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * The Notes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Notes;
    /**
     * Constructor method for InsertInvoiceNote
     * @uses InsertInvoiceNote::setInvoiceId()
     * @uses InsertInvoiceNote::setNoteDate()
     * @uses InsertInvoiceNote::setUserName()
     * @uses InsertInvoiceNote::setPassword()
     * @uses InsertInvoiceNote::setNotes()
     * @param int $invoiceId
     * @param string $noteDate
     * @param string $userName
     * @param string $password
     * @param string $notes
     */
    public function __construct($invoiceId = null, $noteDate = null, $userName = null, $password = null, $notes = null)
    {
        $this
            ->setInvoiceId($invoiceId)
            ->setNoteDate($noteDate)
            ->setUserName($userName)
            ->setPassword($password)
            ->setNotes($notes);
    }
    /**
     * Get InvoiceId value
     * @return int
     */
    public function getInvoiceId()
    {
        return $this->InvoiceId;
    }
    /**
     * Set InvoiceId value
     * @param int $invoiceId
     * @return \StructType\InsertInvoiceNote
     */
    public function setInvoiceId($invoiceId = null)
    {
        // validation for constraint: int
        if (!is_null($invoiceId) && !(is_int($invoiceId) || ctype_digit($invoiceId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($invoiceId, true), gettype($invoiceId)), __LINE__);
        }
        $this->InvoiceId = $invoiceId;
        return $this;
    }
    /**
     * Get NoteDate value
     * @return string
     */
    public function getNoteDate()
    {
        return $this->NoteDate;
    }
    /**
     * Set NoteDate value
     * @param string $noteDate
     * @return \StructType\InsertInvoiceNote
     */
    public function setNoteDate($noteDate = null)
    {
        // validation for constraint: string
        if (!is_null($noteDate) && !is_string($noteDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($noteDate, true), gettype($noteDate)), __LINE__);
        }
        $this->NoteDate = $noteDate;
        return $this;
    }
    /**
     * Get UserName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->UserName;
    }
    /**
     * Set UserName value
     * @param string $userName
     * @return \StructType\InsertInvoiceNote
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userName, true), gettype($userName)), __LINE__);
        }
        $this->UserName = $userName;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\InsertInvoiceNote
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get Notes value
     * @return string|null
     */
    public function getNotes()
    {
        return $this->Notes;
    }
    /**
     * Set Notes value
     * @param string $notes
     * @return \StructType\InsertInvoiceNote
     */
    public function setNotes($notes = null)
    {
        // validation for constraint: string
        if (!is_null($notes) && !is_string($notes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notes, true), gettype($notes)), __LINE__);
        }
        $this->Notes = $notes;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InsertInvoiceNote
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
