<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetReceipts_Recent StructType
 * @subpackage Structs
 */
class GetReceipts_Recent extends AbstractStructBase
{
    /**
     * The NumberOfReceipts
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $NumberOfReceipts;
    /**
     * The UserName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UserName;
    /**
     * The Password
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * Constructor method for GetReceipts_Recent
     * @uses GetReceipts_Recent::setNumberOfReceipts()
     * @uses GetReceipts_Recent::setUserName()
     * @uses GetReceipts_Recent::setPassword()
     * @param int $numberOfReceipts
     * @param string $userName
     * @param string $password
     */
    public function __construct($numberOfReceipts = null, $userName = null, $password = null)
    {
        $this
            ->setNumberOfReceipts($numberOfReceipts)
            ->setUserName($userName)
            ->setPassword($password);
    }
    /**
     * Get NumberOfReceipts value
     * @return int
     */
    public function getNumberOfReceipts()
    {
        return $this->NumberOfReceipts;
    }
    /**
     * Set NumberOfReceipts value
     * @param int $numberOfReceipts
     * @return \StructType\GetReceipts_Recent
     */
    public function setNumberOfReceipts($numberOfReceipts = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfReceipts) && !(is_int($numberOfReceipts) || ctype_digit($numberOfReceipts))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfReceipts, true), gettype($numberOfReceipts)), __LINE__);
        }
        $this->NumberOfReceipts = $numberOfReceipts;
        return $this;
    }
    /**
     * Get UserName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->UserName;
    }
    /**
     * Set UserName value
     * @param string $userName
     * @return \StructType\GetReceipts_Recent
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userName, true), gettype($userName)), __LINE__);
        }
        $this->UserName = $userName;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\GetReceipts_Recent
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetReceipts_Recent
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
