<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetReceiptsWithPaging StructType
 * @subpackage Structs
 */
class GetReceiptsWithPaging extends AbstractStructBase
{
    /**
     * The Page
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Page;
    /**
     * The PerPage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PerPage;
    /**
     * The UserName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UserName;
    /**
     * The Password
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * The FilterBy
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FilterBy;
    /**
     * Constructor method for GetReceiptsWithPaging
     * @uses GetReceiptsWithPaging::setPage()
     * @uses GetReceiptsWithPaging::setPerPage()
     * @uses GetReceiptsWithPaging::setUserName()
     * @uses GetReceiptsWithPaging::setPassword()
     * @uses GetReceiptsWithPaging::setFilterBy()
     * @param int $page
     * @param int $perPage
     * @param string $userName
     * @param string $password
     * @param string $filterBy
     */
    public function __construct($page = null, $perPage = null, $userName = null, $password = null, $filterBy = null)
    {
        $this
            ->setPage($page)
            ->setPerPage($perPage)
            ->setUserName($userName)
            ->setPassword($password)
            ->setFilterBy($filterBy);
    }
    /**
     * Get Page value
     * @return int
     */
    public function getPage()
    {
        return $this->Page;
    }
    /**
     * Set Page value
     * @param int $page
     * @return \StructType\GetReceiptsWithPaging
     */
    public function setPage($page = null)
    {
        // validation for constraint: int
        if (!is_null($page) && !(is_int($page) || ctype_digit($page))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($page, true), gettype($page)), __LINE__);
        }
        $this->Page = $page;
        return $this;
    }
    /**
     * Get PerPage value
     * @return int
     */
    public function getPerPage()
    {
        return $this->PerPage;
    }
    /**
     * Set PerPage value
     * @param int $perPage
     * @return \StructType\GetReceiptsWithPaging
     */
    public function setPerPage($perPage = null)
    {
        // validation for constraint: int
        if (!is_null($perPage) && !(is_int($perPage) || ctype_digit($perPage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($perPage, true), gettype($perPage)), __LINE__);
        }
        $this->PerPage = $perPage;
        return $this;
    }
    /**
     * Get UserName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->UserName;
    }
    /**
     * Set UserName value
     * @param string $userName
     * @return \StructType\GetReceiptsWithPaging
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userName, true), gettype($userName)), __LINE__);
        }
        $this->UserName = $userName;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\GetReceiptsWithPaging
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get FilterBy value
     * @return string|null
     */
    public function getFilterBy()
    {
        return $this->FilterBy;
    }
    /**
     * Set FilterBy value
     * @param string $filterBy
     * @return \StructType\GetReceiptsWithPaging
     */
    public function setFilterBy($filterBy = null)
    {
        // validation for constraint: string
        if (!is_null($filterBy) && !is_string($filterBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($filterBy, true), gettype($filterBy)), __LINE__);
        }
        $this->FilterBy = $filterBy;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetReceiptsWithPaging
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
