<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetQuotes_Recent StructType
 * @subpackage Structs
 */
class GetQuotes_Recent extends AbstractStructBase
{
    /**
     * The NumberOfQuotes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $NumberOfQuotes;
    /**
     * The UserName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UserName;
    /**
     * The Password
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * Constructor method for GetQuotes_Recent
     * @uses GetQuotes_Recent::setNumberOfQuotes()
     * @uses GetQuotes_Recent::setUserName()
     * @uses GetQuotes_Recent::setPassword()
     * @param int $numberOfQuotes
     * @param string $userName
     * @param string $password
     */
    public function __construct($numberOfQuotes = null, $userName = null, $password = null)
    {
        $this
            ->setNumberOfQuotes($numberOfQuotes)
            ->setUserName($userName)
            ->setPassword($password);
    }
    /**
     * Get NumberOfQuotes value
     * @return int
     */
    public function getNumberOfQuotes()
    {
        return $this->NumberOfQuotes;
    }
    /**
     * Set NumberOfQuotes value
     * @param int $numberOfQuotes
     * @return \StructType\GetQuotes_Recent
     */
    public function setNumberOfQuotes($numberOfQuotes = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfQuotes) && !(is_int($numberOfQuotes) || ctype_digit($numberOfQuotes))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfQuotes, true), gettype($numberOfQuotes)), __LINE__);
        }
        $this->NumberOfQuotes = $numberOfQuotes;
        return $this;
    }
    /**
     * Get UserName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->UserName;
    }
    /**
     * Set UserName value
     * @param string $userName
     * @return \StructType\GetQuotes_Recent
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userName, true), gettype($userName)), __LINE__);
        }
        $this->UserName = $userName;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\GetQuotes_Recent
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetQuotes_Recent
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
