<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetIncomeByCustomer StructType
 * @subpackage Structs
 */
class GetIncomeByCustomer extends AbstractStructBase
{
    /**
     * The StartDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $StartDate;
    /**
     * The EndDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $EndDate;
    /**
     * The BasedOnInvoiceDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $BasedOnInvoiceDate;
    /**
     * The UserName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UserName;
    /**
     * The Password
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * Constructor method for GetIncomeByCustomer
     * @uses GetIncomeByCustomer::setStartDate()
     * @uses GetIncomeByCustomer::setEndDate()
     * @uses GetIncomeByCustomer::setBasedOnInvoiceDate()
     * @uses GetIncomeByCustomer::setUserName()
     * @uses GetIncomeByCustomer::setPassword()
     * @param string $startDate
     * @param string $endDate
     * @param bool $basedOnInvoiceDate
     * @param string $userName
     * @param string $password
     */
    public function __construct($startDate = null, $endDate = null, $basedOnInvoiceDate = null, $userName = null, $password = null)
    {
        $this
            ->setStartDate($startDate)
            ->setEndDate($endDate)
            ->setBasedOnInvoiceDate($basedOnInvoiceDate)
            ->setUserName($userName)
            ->setPassword($password);
    }
    /**
     * Get StartDate value
     * @return string
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }
    /**
     * Set StartDate value
     * @param string $startDate
     * @return \StructType\GetIncomeByCustomer
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        $this->StartDate = $startDate;
        return $this;
    }
    /**
     * Get EndDate value
     * @return string
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }
    /**
     * Set EndDate value
     * @param string $endDate
     * @return \StructType\GetIncomeByCustomer
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        $this->EndDate = $endDate;
        return $this;
    }
    /**
     * Get BasedOnInvoiceDate value
     * @return bool
     */
    public function getBasedOnInvoiceDate()
    {
        return $this->BasedOnInvoiceDate;
    }
    /**
     * Set BasedOnInvoiceDate value
     * @param bool $basedOnInvoiceDate
     * @return \StructType\GetIncomeByCustomer
     */
    public function setBasedOnInvoiceDate($basedOnInvoiceDate = null)
    {
        // validation for constraint: boolean
        if (!is_null($basedOnInvoiceDate) && !is_bool($basedOnInvoiceDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($basedOnInvoiceDate, true), gettype($basedOnInvoiceDate)), __LINE__);
        }
        $this->BasedOnInvoiceDate = $basedOnInvoiceDate;
        return $this;
    }
    /**
     * Get UserName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->UserName;
    }
    /**
     * Set UserName value
     * @param string $userName
     * @return \StructType\GetIncomeByCustomer
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userName, true), gettype($userName)), __LINE__);
        }
        $this->UserName = $userName;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\GetIncomeByCustomer
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetIncomeByCustomer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
