<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CompanyDetails StructType
 * @subpackage Structs
 */
class CompanyDetails extends AbstractStructBase
{
    /**
     * The PaymentTerms
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PaymentTerms;
    /**
     * The CurrencyId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CurrencyId;
    /**
     * The BusinessType1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BusinessType1;
    /**
     * The BusinessType2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BusinessType2;
    /**
     * The BusinessType3
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BusinessType3;
    /**
     * The BusinessType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BusinessType;
    /**
     * The CompanyName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CompanyName;
    /**
     * The Address1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Address1;
    /**
     * The Address2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Address2;
    /**
     * The Address3
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Address3;
    /**
     * The Address4
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Address4;
    /**
     * The Postcode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Postcode;
    /**
     * The PrimaryEmail
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PrimaryEmail;
    /**
     * The PrimaryContact
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PrimaryContact;
    /**
     * The Telephone
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Telephone;
    /**
     * The Mobile
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Mobile;
    /**
     * The VatRegistered
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VatRegistered;
    /**
     * The VatRegistrationNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VatRegistrationNumber;
    /**
     * The CurrencySymbol
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CurrencySymbol;
    /**
     * The CurrencyPosition
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CurrencyPosition;
    /**
     * The UsDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UsDate;
    /**
     * The CurrencyName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CurrencyName;
    /**
     * The PaymentTermsType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentTermsType;
    /**
     * The BusinessType1Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BusinessType1Name;
    /**
     * The BusinessType2Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BusinessType2Name;
    /**
     * The BusinessType3Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BusinessType3Name;
    /**
     * Constructor method for CompanyDetails
     * @uses CompanyDetails::setPaymentTerms()
     * @uses CompanyDetails::setCurrencyId()
     * @uses CompanyDetails::setBusinessType1()
     * @uses CompanyDetails::setBusinessType2()
     * @uses CompanyDetails::setBusinessType3()
     * @uses CompanyDetails::setBusinessType()
     * @uses CompanyDetails::setCompanyName()
     * @uses CompanyDetails::setAddress1()
     * @uses CompanyDetails::setAddress2()
     * @uses CompanyDetails::setAddress3()
     * @uses CompanyDetails::setAddress4()
     * @uses CompanyDetails::setPostcode()
     * @uses CompanyDetails::setPrimaryEmail()
     * @uses CompanyDetails::setPrimaryContact()
     * @uses CompanyDetails::setTelephone()
     * @uses CompanyDetails::setMobile()
     * @uses CompanyDetails::setVatRegistered()
     * @uses CompanyDetails::setVatRegistrationNumber()
     * @uses CompanyDetails::setCurrencySymbol()
     * @uses CompanyDetails::setCurrencyPosition()
     * @uses CompanyDetails::setUsDate()
     * @uses CompanyDetails::setCurrencyName()
     * @uses CompanyDetails::setPaymentTermsType()
     * @uses CompanyDetails::setBusinessType1Name()
     * @uses CompanyDetails::setBusinessType2Name()
     * @uses CompanyDetails::setBusinessType3Name()
     * @param int $paymentTerms
     * @param int $currencyId
     * @param int $businessType1
     * @param int $businessType2
     * @param int $businessType3
     * @param int $businessType
     * @param string $companyName
     * @param string $address1
     * @param string $address2
     * @param string $address3
     * @param string $address4
     * @param string $postcode
     * @param string $primaryEmail
     * @param string $primaryContact
     * @param string $telephone
     * @param string $mobile
     * @param string $vatRegistered
     * @param string $vatRegistrationNumber
     * @param string $currencySymbol
     * @param string $currencyPosition
     * @param string $usDate
     * @param string $currencyName
     * @param string $paymentTermsType
     * @param string $businessType1Name
     * @param string $businessType2Name
     * @param string $businessType3Name
     */
    public function __construct($paymentTerms = null, $currencyId = null, $businessType1 = null, $businessType2 = null, $businessType3 = null, $businessType = null, $companyName = null, $address1 = null, $address2 = null, $address3 = null, $address4 = null, $postcode = null, $primaryEmail = null, $primaryContact = null, $telephone = null, $mobile = null, $vatRegistered = null, $vatRegistrationNumber = null, $currencySymbol = null, $currencyPosition = null, $usDate = null, $currencyName = null, $paymentTermsType = null, $businessType1Name = null, $businessType2Name = null, $businessType3Name = null)
    {
        $this
            ->setPaymentTerms($paymentTerms)
            ->setCurrencyId($currencyId)
            ->setBusinessType1($businessType1)
            ->setBusinessType2($businessType2)
            ->setBusinessType3($businessType3)
            ->setBusinessType($businessType)
            ->setCompanyName($companyName)
            ->setAddress1($address1)
            ->setAddress2($address2)
            ->setAddress3($address3)
            ->setAddress4($address4)
            ->setPostcode($postcode)
            ->setPrimaryEmail($primaryEmail)
            ->setPrimaryContact($primaryContact)
            ->setTelephone($telephone)
            ->setMobile($mobile)
            ->setVatRegistered($vatRegistered)
            ->setVatRegistrationNumber($vatRegistrationNumber)
            ->setCurrencySymbol($currencySymbol)
            ->setCurrencyPosition($currencyPosition)
            ->setUsDate($usDate)
            ->setCurrencyName($currencyName)
            ->setPaymentTermsType($paymentTermsType)
            ->setBusinessType1Name($businessType1Name)
            ->setBusinessType2Name($businessType2Name)
            ->setBusinessType3Name($businessType3Name);
    }
    /**
     * Get PaymentTerms value
     * @return int
     */
    public function getPaymentTerms()
    {
        return $this->PaymentTerms;
    }
    /**
     * Set PaymentTerms value
     * @param int $paymentTerms
     * @return \StructType\CompanyDetails
     */
    public function setPaymentTerms($paymentTerms = null)
    {
        // validation for constraint: int
        if (!is_null($paymentTerms) && !(is_int($paymentTerms) || ctype_digit($paymentTerms))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($paymentTerms, true), gettype($paymentTerms)), __LINE__);
        }
        $this->PaymentTerms = $paymentTerms;
        return $this;
    }
    /**
     * Get CurrencyId value
     * @return int
     */
    public function getCurrencyId()
    {
        return $this->CurrencyId;
    }
    /**
     * Set CurrencyId value
     * @param int $currencyId
     * @return \StructType\CompanyDetails
     */
    public function setCurrencyId($currencyId = null)
    {
        // validation for constraint: int
        if (!is_null($currencyId) && !(is_int($currencyId) || ctype_digit($currencyId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($currencyId, true), gettype($currencyId)), __LINE__);
        }
        $this->CurrencyId = $currencyId;
        return $this;
    }
    /**
     * Get BusinessType1 value
     * @return int
     */
    public function getBusinessType1()
    {
        return $this->BusinessType1;
    }
    /**
     * Set BusinessType1 value
     * @param int $businessType1
     * @return \StructType\CompanyDetails
     */
    public function setBusinessType1($businessType1 = null)
    {
        // validation for constraint: int
        if (!is_null($businessType1) && !(is_int($businessType1) || ctype_digit($businessType1))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($businessType1, true), gettype($businessType1)), __LINE__);
        }
        $this->BusinessType1 = $businessType1;
        return $this;
    }
    /**
     * Get BusinessType2 value
     * @return int
     */
    public function getBusinessType2()
    {
        return $this->BusinessType2;
    }
    /**
     * Set BusinessType2 value
     * @param int $businessType2
     * @return \StructType\CompanyDetails
     */
    public function setBusinessType2($businessType2 = null)
    {
        // validation for constraint: int
        if (!is_null($businessType2) && !(is_int($businessType2) || ctype_digit($businessType2))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($businessType2, true), gettype($businessType2)), __LINE__);
        }
        $this->BusinessType2 = $businessType2;
        return $this;
    }
    /**
     * Get BusinessType3 value
     * @return int
     */
    public function getBusinessType3()
    {
        return $this->BusinessType3;
    }
    /**
     * Set BusinessType3 value
     * @param int $businessType3
     * @return \StructType\CompanyDetails
     */
    public function setBusinessType3($businessType3 = null)
    {
        // validation for constraint: int
        if (!is_null($businessType3) && !(is_int($businessType3) || ctype_digit($businessType3))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($businessType3, true), gettype($businessType3)), __LINE__);
        }
        $this->BusinessType3 = $businessType3;
        return $this;
    }
    /**
     * Get BusinessType value
     * @return int
     */
    public function getBusinessType()
    {
        return $this->BusinessType;
    }
    /**
     * Set BusinessType value
     * @param int $businessType
     * @return \StructType\CompanyDetails
     */
    public function setBusinessType($businessType = null)
    {
        // validation for constraint: int
        if (!is_null($businessType) && !(is_int($businessType) || ctype_digit($businessType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($businessType, true), gettype($businessType)), __LINE__);
        }
        $this->BusinessType = $businessType;
        return $this;
    }
    /**
     * Get CompanyName value
     * @return string|null
     */
    public function getCompanyName()
    {
        return $this->CompanyName;
    }
    /**
     * Set CompanyName value
     * @param string $companyName
     * @return \StructType\CompanyDetails
     */
    public function setCompanyName($companyName = null)
    {
        // validation for constraint: string
        if (!is_null($companyName) && !is_string($companyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($companyName, true), gettype($companyName)), __LINE__);
        }
        $this->CompanyName = $companyName;
        return $this;
    }
    /**
     * Get Address1 value
     * @return string|null
     */
    public function getAddress1()
    {
        return $this->Address1;
    }
    /**
     * Set Address1 value
     * @param string $address1
     * @return \StructType\CompanyDetails
     */
    public function setAddress1($address1 = null)
    {
        // validation for constraint: string
        if (!is_null($address1) && !is_string($address1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address1, true), gettype($address1)), __LINE__);
        }
        $this->Address1 = $address1;
        return $this;
    }
    /**
     * Get Address2 value
     * @return string|null
     */
    public function getAddress2()
    {
        return $this->Address2;
    }
    /**
     * Set Address2 value
     * @param string $address2
     * @return \StructType\CompanyDetails
     */
    public function setAddress2($address2 = null)
    {
        // validation for constraint: string
        if (!is_null($address2) && !is_string($address2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address2, true), gettype($address2)), __LINE__);
        }
        $this->Address2 = $address2;
        return $this;
    }
    /**
     * Get Address3 value
     * @return string|null
     */
    public function getAddress3()
    {
        return $this->Address3;
    }
    /**
     * Set Address3 value
     * @param string $address3
     * @return \StructType\CompanyDetails
     */
    public function setAddress3($address3 = null)
    {
        // validation for constraint: string
        if (!is_null($address3) && !is_string($address3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address3, true), gettype($address3)), __LINE__);
        }
        $this->Address3 = $address3;
        return $this;
    }
    /**
     * Get Address4 value
     * @return string|null
     */
    public function getAddress4()
    {
        return $this->Address4;
    }
    /**
     * Set Address4 value
     * @param string $address4
     * @return \StructType\CompanyDetails
     */
    public function setAddress4($address4 = null)
    {
        // validation for constraint: string
        if (!is_null($address4) && !is_string($address4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address4, true), gettype($address4)), __LINE__);
        }
        $this->Address4 = $address4;
        return $this;
    }
    /**
     * Get Postcode value
     * @return string|null
     */
    public function getPostcode()
    {
        return $this->Postcode;
    }
    /**
     * Set Postcode value
     * @param string $postcode
     * @return \StructType\CompanyDetails
     */
    public function setPostcode($postcode = null)
    {
        // validation for constraint: string
        if (!is_null($postcode) && !is_string($postcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postcode, true), gettype($postcode)), __LINE__);
        }
        $this->Postcode = $postcode;
        return $this;
    }
    /**
     * Get PrimaryEmail value
     * @return string|null
     */
    public function getPrimaryEmail()
    {
        return $this->PrimaryEmail;
    }
    /**
     * Set PrimaryEmail value
     * @param string $primaryEmail
     * @return \StructType\CompanyDetails
     */
    public function setPrimaryEmail($primaryEmail = null)
    {
        // validation for constraint: string
        if (!is_null($primaryEmail) && !is_string($primaryEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($primaryEmail, true), gettype($primaryEmail)), __LINE__);
        }
        $this->PrimaryEmail = $primaryEmail;
        return $this;
    }
    /**
     * Get PrimaryContact value
     * @return string|null
     */
    public function getPrimaryContact()
    {
        return $this->PrimaryContact;
    }
    /**
     * Set PrimaryContact value
     * @param string $primaryContact
     * @return \StructType\CompanyDetails
     */
    public function setPrimaryContact($primaryContact = null)
    {
        // validation for constraint: string
        if (!is_null($primaryContact) && !is_string($primaryContact)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($primaryContact, true), gettype($primaryContact)), __LINE__);
        }
        $this->PrimaryContact = $primaryContact;
        return $this;
    }
    /**
     * Get Telephone value
     * @return string|null
     */
    public function getTelephone()
    {
        return $this->Telephone;
    }
    /**
     * Set Telephone value
     * @param string $telephone
     * @return \StructType\CompanyDetails
     */
    public function setTelephone($telephone = null)
    {
        // validation for constraint: string
        if (!is_null($telephone) && !is_string($telephone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($telephone, true), gettype($telephone)), __LINE__);
        }
        $this->Telephone = $telephone;
        return $this;
    }
    /**
     * Get Mobile value
     * @return string|null
     */
    public function getMobile()
    {
        return $this->Mobile;
    }
    /**
     * Set Mobile value
     * @param string $mobile
     * @return \StructType\CompanyDetails
     */
    public function setMobile($mobile = null)
    {
        // validation for constraint: string
        if (!is_null($mobile) && !is_string($mobile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mobile, true), gettype($mobile)), __LINE__);
        }
        $this->Mobile = $mobile;
        return $this;
    }
    /**
     * Get VatRegistered value
     * @return string|null
     */
    public function getVatRegistered()
    {
        return $this->VatRegistered;
    }
    /**
     * Set VatRegistered value
     * @param string $vatRegistered
     * @return \StructType\CompanyDetails
     */
    public function setVatRegistered($vatRegistered = null)
    {
        // validation for constraint: string
        if (!is_null($vatRegistered) && !is_string($vatRegistered)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vatRegistered, true), gettype($vatRegistered)), __LINE__);
        }
        $this->VatRegistered = $vatRegistered;
        return $this;
    }
    /**
     * Get VatRegistrationNumber value
     * @return string|null
     */
    public function getVatRegistrationNumber()
    {
        return $this->VatRegistrationNumber;
    }
    /**
     * Set VatRegistrationNumber value
     * @param string $vatRegistrationNumber
     * @return \StructType\CompanyDetails
     */
    public function setVatRegistrationNumber($vatRegistrationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($vatRegistrationNumber) && !is_string($vatRegistrationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vatRegistrationNumber, true), gettype($vatRegistrationNumber)), __LINE__);
        }
        $this->VatRegistrationNumber = $vatRegistrationNumber;
        return $this;
    }
    /**
     * Get CurrencySymbol value
     * @return string|null
     */
    public function getCurrencySymbol()
    {
        return $this->CurrencySymbol;
    }
    /**
     * Set CurrencySymbol value
     * @param string $currencySymbol
     * @return \StructType\CompanyDetails
     */
    public function setCurrencySymbol($currencySymbol = null)
    {
        // validation for constraint: string
        if (!is_null($currencySymbol) && !is_string($currencySymbol)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencySymbol, true), gettype($currencySymbol)), __LINE__);
        }
        $this->CurrencySymbol = $currencySymbol;
        return $this;
    }
    /**
     * Get CurrencyPosition value
     * @return string|null
     */
    public function getCurrencyPosition()
    {
        return $this->CurrencyPosition;
    }
    /**
     * Set CurrencyPosition value
     * @param string $currencyPosition
     * @return \StructType\CompanyDetails
     */
    public function setCurrencyPosition($currencyPosition = null)
    {
        // validation for constraint: string
        if (!is_null($currencyPosition) && !is_string($currencyPosition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyPosition, true), gettype($currencyPosition)), __LINE__);
        }
        $this->CurrencyPosition = $currencyPosition;
        return $this;
    }
    /**
     * Get UsDate value
     * @return string|null
     */
    public function getUsDate()
    {
        return $this->UsDate;
    }
    /**
     * Set UsDate value
     * @param string $usDate
     * @return \StructType\CompanyDetails
     */
    public function setUsDate($usDate = null)
    {
        // validation for constraint: string
        if (!is_null($usDate) && !is_string($usDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usDate, true), gettype($usDate)), __LINE__);
        }
        $this->UsDate = $usDate;
        return $this;
    }
    /**
     * Get CurrencyName value
     * @return string|null
     */
    public function getCurrencyName()
    {
        return $this->CurrencyName;
    }
    /**
     * Set CurrencyName value
     * @param string $currencyName
     * @return \StructType\CompanyDetails
     */
    public function setCurrencyName($currencyName = null)
    {
        // validation for constraint: string
        if (!is_null($currencyName) && !is_string($currencyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyName, true), gettype($currencyName)), __LINE__);
        }
        $this->CurrencyName = $currencyName;
        return $this;
    }
    /**
     * Get PaymentTermsType value
     * @return string|null
     */
    public function getPaymentTermsType()
    {
        return $this->PaymentTermsType;
    }
    /**
     * Set PaymentTermsType value
     * @param string $paymentTermsType
     * @return \StructType\CompanyDetails
     */
    public function setPaymentTermsType($paymentTermsType = null)
    {
        // validation for constraint: string
        if (!is_null($paymentTermsType) && !is_string($paymentTermsType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentTermsType, true), gettype($paymentTermsType)), __LINE__);
        }
        $this->PaymentTermsType = $paymentTermsType;
        return $this;
    }
    /**
     * Get BusinessType1Name value
     * @return string|null
     */
    public function getBusinessType1Name()
    {
        return $this->BusinessType1Name;
    }
    /**
     * Set BusinessType1Name value
     * @param string $businessType1Name
     * @return \StructType\CompanyDetails
     */
    public function setBusinessType1Name($businessType1Name = null)
    {
        // validation for constraint: string
        if (!is_null($businessType1Name) && !is_string($businessType1Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($businessType1Name, true), gettype($businessType1Name)), __LINE__);
        }
        $this->BusinessType1Name = $businessType1Name;
        return $this;
    }
    /**
     * Get BusinessType2Name value
     * @return string|null
     */
    public function getBusinessType2Name()
    {
        return $this->BusinessType2Name;
    }
    /**
     * Set BusinessType2Name value
     * @param string $businessType2Name
     * @return \StructType\CompanyDetails
     */
    public function setBusinessType2Name($businessType2Name = null)
    {
        // validation for constraint: string
        if (!is_null($businessType2Name) && !is_string($businessType2Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($businessType2Name, true), gettype($businessType2Name)), __LINE__);
        }
        $this->BusinessType2Name = $businessType2Name;
        return $this;
    }
    /**
     * Get BusinessType3Name value
     * @return string|null
     */
    public function getBusinessType3Name()
    {
        return $this->BusinessType3Name;
    }
    /**
     * Set BusinessType3Name value
     * @param string $businessType3Name
     * @return \StructType\CompanyDetails
     */
    public function setBusinessType3Name($businessType3Name = null)
    {
        // validation for constraint: string
        if (!is_null($businessType3Name) && !is_string($businessType3Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($businessType3Name, true), gettype($businessType3Name)), __LINE__);
        }
        $this->BusinessType3Name = $businessType3Name;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CompanyDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
