<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BankTXType StructType
 * @subpackage Structs
 */
class BankTXType extends AbstractStructBase
{
    /**
     * The TypeID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TypeID;
    /**
     * The TypeCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TypeCode;
    /**
     * The TypeName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TypeName;
    /**
     * Constructor method for BankTXType
     * @uses BankTXType::setTypeID()
     * @uses BankTXType::setTypeCode()
     * @uses BankTXType::setTypeName()
     * @param int $typeID
     * @param int $typeCode
     * @param string $typeName
     */
    public function __construct($typeID = null, $typeCode = null, $typeName = null)
    {
        $this
            ->setTypeID($typeID)
            ->setTypeCode($typeCode)
            ->setTypeName($typeName);
    }
    /**
     * Get TypeID value
     * @return int
     */
    public function getTypeID()
    {
        return $this->TypeID;
    }
    /**
     * Set TypeID value
     * @param int $typeID
     * @return \StructType\BankTXType
     */
    public function setTypeID($typeID = null)
    {
        // validation for constraint: int
        if (!is_null($typeID) && !(is_int($typeID) || ctype_digit($typeID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($typeID, true), gettype($typeID)), __LINE__);
        }
        $this->TypeID = $typeID;
        return $this;
    }
    /**
     * Get TypeCode value
     * @return int
     */
    public function getTypeCode()
    {
        return $this->TypeCode;
    }
    /**
     * Set TypeCode value
     * @param int $typeCode
     * @return \StructType\BankTXType
     */
    public function setTypeCode($typeCode = null)
    {
        // validation for constraint: int
        if (!is_null($typeCode) && !(is_int($typeCode) || ctype_digit($typeCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($typeCode, true), gettype($typeCode)), __LINE__);
        }
        $this->TypeCode = $typeCode;
        return $this;
    }
    /**
     * Get TypeName value
     * @return string|null
     */
    public function getTypeName()
    {
        return $this->TypeName;
    }
    /**
     * Set TypeName value
     * @param string $typeName
     * @return \StructType\BankTXType
     */
    public function setTypeName($typeName = null)
    {
        // validation for constraint: string
        if (!is_null($typeName) && !is_string($typeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeName, true), gettype($typeName)), __LINE__);
        }
        $this->TypeName = $typeName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BankTXType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
