<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BankAccount StructType
 * @subpackage Structs
 */
class BankAccount extends AbstractStructBase
{
    /**
     * The AccountID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountID;
    /**
     * The AccountCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountCode;
    /**
     * The AccountName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountName;
    /**
     * Constructor method for BankAccount
     * @uses BankAccount::setAccountID()
     * @uses BankAccount::setAccountCode()
     * @uses BankAccount::setAccountName()
     * @param int $accountID
     * @param int $accountCode
     * @param string $accountName
     */
    public function __construct($accountID = null, $accountCode = null, $accountName = null)
    {
        $this
            ->setAccountID($accountID)
            ->setAccountCode($accountCode)
            ->setAccountName($accountName);
    }
    /**
     * Get AccountID value
     * @return int
     */
    public function getAccountID()
    {
        return $this->AccountID;
    }
    /**
     * Set AccountID value
     * @param int $accountID
     * @return \StructType\BankAccount
     */
    public function setAccountID($accountID = null)
    {
        // validation for constraint: int
        if (!is_null($accountID) && !(is_int($accountID) || ctype_digit($accountID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($accountID, true), gettype($accountID)), __LINE__);
        }
        $this->AccountID = $accountID;
        return $this;
    }
    /**
     * Get AccountCode value
     * @return int
     */
    public function getAccountCode()
    {
        return $this->AccountCode;
    }
    /**
     * Set AccountCode value
     * @param int $accountCode
     * @return \StructType\BankAccount
     */
    public function setAccountCode($accountCode = null)
    {
        // validation for constraint: int
        if (!is_null($accountCode) && !(is_int($accountCode) || ctype_digit($accountCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($accountCode, true), gettype($accountCode)), __LINE__);
        }
        $this->AccountCode = $accountCode;
        return $this;
    }
    /**
     * Get AccountName value
     * @return string|null
     */
    public function getAccountName()
    {
        return $this->AccountName;
    }
    /**
     * Set AccountName value
     * @param string $accountName
     * @return \StructType\BankAccount
     */
    public function setAccountName($accountName = null)
    {
        // validation for constraint: string
        if (!is_null($accountName) && !is_string($accountName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountName, true), gettype($accountName)), __LINE__);
        }
        $this->AccountName = $accountName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BankAccount
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
