<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AutoAuthIP StructType
 * @subpackage Structs
 */
class AutoAuthIP extends AbstractStructBase
{
    /**
     * The UserName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UserName;
    /**
     * The Password
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * The appName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $appName;
    /**
     * The AutoAuthKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AutoAuthKey;
    /**
     * Constructor method for AutoAuthIP
     * @uses AutoAuthIP::setUserName()
     * @uses AutoAuthIP::setPassword()
     * @uses AutoAuthIP::setAppName()
     * @uses AutoAuthIP::setAutoAuthKey()
     * @param string $userName
     * @param string $password
     * @param string $appName
     * @param string $autoAuthKey
     */
    public function __construct($userName = null, $password = null, $appName = null, $autoAuthKey = null)
    {
        $this
            ->setUserName($userName)
            ->setPassword($password)
            ->setAppName($appName)
            ->setAutoAuthKey($autoAuthKey);
    }
    /**
     * Get UserName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->UserName;
    }
    /**
     * Set UserName value
     * @param string $userName
     * @return \StructType\AutoAuthIP
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userName, true), gettype($userName)), __LINE__);
        }
        $this->UserName = $userName;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\AutoAuthIP
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get appName value
     * @return string|null
     */
    public function getAppName()
    {
        return $this->appName;
    }
    /**
     * Set appName value
     * @param string $appName
     * @return \StructType\AutoAuthIP
     */
    public function setAppName($appName = null)
    {
        // validation for constraint: string
        if (!is_null($appName) && !is_string($appName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($appName, true), gettype($appName)), __LINE__);
        }
        $this->appName = $appName;
        return $this;
    }
    /**
     * Get AutoAuthKey value
     * @return string|null
     */
    public function getAutoAuthKey()
    {
        return $this->AutoAuthKey;
    }
    /**
     * Set AutoAuthKey value
     * @param string $autoAuthKey
     * @return \StructType\AutoAuthIP
     */
    public function setAutoAuthKey($autoAuthKey = null)
    {
        // validation for constraint: string
        if (!is_null($autoAuthKey) && !is_string($autoAuthKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($autoAuthKey, true), gettype($autoAuthKey)), __LINE__);
        }
        $this->AutoAuthKey = $autoAuthKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AutoAuthIP
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
