<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountOverview StructType
 * @subpackage Structs
 */
class AccountOverview extends AbstractStructBase
{
    /**
     * The TotalDue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalDue;
    /**
     * The TotalOwed
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalOwed;
    /**
     * The ReceiptsOverdue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ReceiptsOverdue;
    /**
     * The SalesOverdue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $SalesOverdue;
    /**
     * The ReceiptPartPayments
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ReceiptPartPayments;
    /**
     * The ReceiptPartPaymentsOverdue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ReceiptPartPaymentsOverdue;
    /**
     * The InvoicePartPayments
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $InvoicePartPayments;
    /**
     * The InvoicePartPaymentsOverdue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $InvoicePartPaymentsOverdue;
    /**
     * Constructor method for AccountOverview
     * @uses AccountOverview::setTotalDue()
     * @uses AccountOverview::setTotalOwed()
     * @uses AccountOverview::setReceiptsOverdue()
     * @uses AccountOverview::setSalesOverdue()
     * @uses AccountOverview::setReceiptPartPayments()
     * @uses AccountOverview::setReceiptPartPaymentsOverdue()
     * @uses AccountOverview::setInvoicePartPayments()
     * @uses AccountOverview::setInvoicePartPaymentsOverdue()
     * @param float $totalDue
     * @param float $totalOwed
     * @param float $receiptsOverdue
     * @param float $salesOverdue
     * @param float $receiptPartPayments
     * @param float $receiptPartPaymentsOverdue
     * @param float $invoicePartPayments
     * @param float $invoicePartPaymentsOverdue
     */
    public function __construct($totalDue = null, $totalOwed = null, $receiptsOverdue = null, $salesOverdue = null, $receiptPartPayments = null, $receiptPartPaymentsOverdue = null, $invoicePartPayments = null, $invoicePartPaymentsOverdue = null)
    {
        $this
            ->setTotalDue($totalDue)
            ->setTotalOwed($totalOwed)
            ->setReceiptsOverdue($receiptsOverdue)
            ->setSalesOverdue($salesOverdue)
            ->setReceiptPartPayments($receiptPartPayments)
            ->setReceiptPartPaymentsOverdue($receiptPartPaymentsOverdue)
            ->setInvoicePartPayments($invoicePartPayments)
            ->setInvoicePartPaymentsOverdue($invoicePartPaymentsOverdue);
    }
    /**
     * Get TotalDue value
     * @return float
     */
    public function getTotalDue()
    {
        return $this->TotalDue;
    }
    /**
     * Set TotalDue value
     * @param float $totalDue
     * @return \StructType\AccountOverview
     */
    public function setTotalDue($totalDue = null)
    {
        // validation for constraint: float
        if (!is_null($totalDue) && !(is_float($totalDue) || is_numeric($totalDue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalDue, true), gettype($totalDue)), __LINE__);
        }
        $this->TotalDue = $totalDue;
        return $this;
    }
    /**
     * Get TotalOwed value
     * @return float
     */
    public function getTotalOwed()
    {
        return $this->TotalOwed;
    }
    /**
     * Set TotalOwed value
     * @param float $totalOwed
     * @return \StructType\AccountOverview
     */
    public function setTotalOwed($totalOwed = null)
    {
        // validation for constraint: float
        if (!is_null($totalOwed) && !(is_float($totalOwed) || is_numeric($totalOwed))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalOwed, true), gettype($totalOwed)), __LINE__);
        }
        $this->TotalOwed = $totalOwed;
        return $this;
    }
    /**
     * Get ReceiptsOverdue value
     * @return float
     */
    public function getReceiptsOverdue()
    {
        return $this->ReceiptsOverdue;
    }
    /**
     * Set ReceiptsOverdue value
     * @param float $receiptsOverdue
     * @return \StructType\AccountOverview
     */
    public function setReceiptsOverdue($receiptsOverdue = null)
    {
        // validation for constraint: float
        if (!is_null($receiptsOverdue) && !(is_float($receiptsOverdue) || is_numeric($receiptsOverdue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($receiptsOverdue, true), gettype($receiptsOverdue)), __LINE__);
        }
        $this->ReceiptsOverdue = $receiptsOverdue;
        return $this;
    }
    /**
     * Get SalesOverdue value
     * @return float
     */
    public function getSalesOverdue()
    {
        return $this->SalesOverdue;
    }
    /**
     * Set SalesOverdue value
     * @param float $salesOverdue
     * @return \StructType\AccountOverview
     */
    public function setSalesOverdue($salesOverdue = null)
    {
        // validation for constraint: float
        if (!is_null($salesOverdue) && !(is_float($salesOverdue) || is_numeric($salesOverdue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($salesOverdue, true), gettype($salesOverdue)), __LINE__);
        }
        $this->SalesOverdue = $salesOverdue;
        return $this;
    }
    /**
     * Get ReceiptPartPayments value
     * @return float
     */
    public function getReceiptPartPayments()
    {
        return $this->ReceiptPartPayments;
    }
    /**
     * Set ReceiptPartPayments value
     * @param float $receiptPartPayments
     * @return \StructType\AccountOverview
     */
    public function setReceiptPartPayments($receiptPartPayments = null)
    {
        // validation for constraint: float
        if (!is_null($receiptPartPayments) && !(is_float($receiptPartPayments) || is_numeric($receiptPartPayments))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($receiptPartPayments, true), gettype($receiptPartPayments)), __LINE__);
        }
        $this->ReceiptPartPayments = $receiptPartPayments;
        return $this;
    }
    /**
     * Get ReceiptPartPaymentsOverdue value
     * @return float
     */
    public function getReceiptPartPaymentsOverdue()
    {
        return $this->ReceiptPartPaymentsOverdue;
    }
    /**
     * Set ReceiptPartPaymentsOverdue value
     * @param float $receiptPartPaymentsOverdue
     * @return \StructType\AccountOverview
     */
    public function setReceiptPartPaymentsOverdue($receiptPartPaymentsOverdue = null)
    {
        // validation for constraint: float
        if (!is_null($receiptPartPaymentsOverdue) && !(is_float($receiptPartPaymentsOverdue) || is_numeric($receiptPartPaymentsOverdue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($receiptPartPaymentsOverdue, true), gettype($receiptPartPaymentsOverdue)), __LINE__);
        }
        $this->ReceiptPartPaymentsOverdue = $receiptPartPaymentsOverdue;
        return $this;
    }
    /**
     * Get InvoicePartPayments value
     * @return float
     */
    public function getInvoicePartPayments()
    {
        return $this->InvoicePartPayments;
    }
    /**
     * Set InvoicePartPayments value
     * @param float $invoicePartPayments
     * @return \StructType\AccountOverview
     */
    public function setInvoicePartPayments($invoicePartPayments = null)
    {
        // validation for constraint: float
        if (!is_null($invoicePartPayments) && !(is_float($invoicePartPayments) || is_numeric($invoicePartPayments))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($invoicePartPayments, true), gettype($invoicePartPayments)), __LINE__);
        }
        $this->InvoicePartPayments = $invoicePartPayments;
        return $this;
    }
    /**
     * Get InvoicePartPaymentsOverdue value
     * @return float
     */
    public function getInvoicePartPaymentsOverdue()
    {
        return $this->InvoicePartPaymentsOverdue;
    }
    /**
     * Set InvoicePartPaymentsOverdue value
     * @param float $invoicePartPaymentsOverdue
     * @return \StructType\AccountOverview
     */
    public function setInvoicePartPaymentsOverdue($invoicePartPaymentsOverdue = null)
    {
        // validation for constraint: float
        if (!is_null($invoicePartPaymentsOverdue) && !(is_float($invoicePartPaymentsOverdue) || is_numeric($invoicePartPaymentsOverdue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($invoicePartPaymentsOverdue, true), gettype($invoicePartPaymentsOverdue)), __LINE__);
        }
        $this->InvoicePartPaymentsOverdue = $invoicePartPaymentsOverdue;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AccountOverview
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
