<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Sage ServiceType
 * @subpackage Services
 */
class Sage extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SageFile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SageFile $parameters
     * @return \StructType\SageFileResponse|bool
     */
    public function SageFile(\StructType\SageFile $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SageFile($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SageFileImport
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SageFileImport $parameters
     * @return \StructType\SageFileImportResponse|bool
     */
    public function SageFileImport(\StructType\SageFileImport $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SageFileImport($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SageFileImportResponse|\StructType\SageFileResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
