<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Email ServiceType
 * @subpackage Services
 */
class Email extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named EmailInvoice
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EmailInvoice $parameters
     * @return \StructType\EmailInvoiceResponse|bool
     */
    public function EmailInvoice(\StructType\EmailInvoice $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EmailInvoice($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EmailPurchaseOrder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EmailPurchaseOrder $parameters
     * @return \StructType\EmailPurchaseOrderResponse|bool
     */
    public function EmailPurchaseOrder(\StructType\EmailPurchaseOrder $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EmailPurchaseOrder($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\EmailInvoiceResponse|\StructType\EmailPurchaseOrderResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
