<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Convert ServiceType
 * @subpackage Services
 */
class Convert extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ConvertQuoteToInvoice
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ConvertQuoteToInvoice $parameters
     * @return \StructType\ConvertQuoteToInvoiceResponse|bool
     */
    public function ConvertQuoteToInvoice(\StructType\ConvertQuoteToInvoice $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ConvertQuoteToInvoice($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ConvertQuoteToInvoiceResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
