<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Auto ServiceType
 * @subpackage Services
 */
class Auto extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named AutoAuthIP
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AutoAuthIP $parameters
     * @return \StructType\AutoAuthIPResponse|bool
     */
    public function AutoAuthIP(\StructType\AutoAuthIP $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AutoAuthIP($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\AutoAuthIPResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
