<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Attach ServiceType
 * @subpackage Services
 */
class Attach extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named AttachFileToReceipt
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AttachFileToReceipt $parameters
     * @return \StructType\AttachFileToReceiptResponse|bool
     */
    public function AttachFileToReceipt(\StructType\AttachFileToReceipt $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AttachFileToReceipt($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\AttachFileToReceiptResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
