<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Apply ServiceType
 * @subpackage Services
 */
class Apply extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named applyCreditNoteToInvoice
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ApplyCreditNoteToInvoice $parameters
     * @return \StructType\ApplyCreditNoteToInvoiceResponse|bool
     */
    public function applyCreditNoteToInvoice(\StructType\ApplyCreditNoteToInvoice $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->applyCreditNoteToInvoice($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ApplyCreditNoteToInvoiceResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
