<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJournalEntry ArrayType
 * @subpackage Arrays
 */
class ArrayOfJournalEntry extends AbstractStructArrayBase
{
    /**
     * The JournalEntry
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\JournalEntry[]
     */
    public $JournalEntry;
    /**
     * Constructor method for ArrayOfJournalEntry
     * @uses ArrayOfJournalEntry::setJournalEntry()
     * @param \StructType\JournalEntry[] $journalEntry
     */
    public function __construct(array $journalEntry = array())
    {
        $this
            ->setJournalEntry($journalEntry);
    }
    /**
     * Get JournalEntry value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\JournalEntry[]|null
     */
    public function getJournalEntry()
    {
        return isset($this->JournalEntry) ? $this->JournalEntry : null;
    }
    /**
     * This method is responsible for validating the values passed to the setJournalEntry method
     * This method is willingly generated in order to preserve the one-line inline validation within the setJournalEntry method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateJournalEntryForArrayConstraintsFromSetJournalEntry(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfJournalEntryJournalEntryItem) {
            // validation for constraint: itemType
            if (!$arrayOfJournalEntryJournalEntryItem instanceof \StructType\JournalEntry) {
                $invalidValues[] = is_object($arrayOfJournalEntryJournalEntryItem) ? get_class($arrayOfJournalEntryJournalEntryItem) : sprintf('%s(%s)', gettype($arrayOfJournalEntryJournalEntryItem), var_export($arrayOfJournalEntryJournalEntryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The JournalEntry property can only contain items of type \StructType\JournalEntry, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set JournalEntry value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\JournalEntry[] $journalEntry
     * @return \ArrayType\ArrayOfJournalEntry
     */
    public function setJournalEntry(array $journalEntry = array())
    {
        // validation for constraint: array
        if ('' !== ($journalEntryArrayErrorMessage = self::validateJournalEntryForArrayConstraintsFromSetJournalEntry($journalEntry))) {
            throw new \InvalidArgumentException($journalEntryArrayErrorMessage, __LINE__);
        }
        if (is_null($journalEntry) || (is_array($journalEntry) && empty($journalEntry))) {
            unset($this->JournalEntry);
        } else {
            $this->JournalEntry = $journalEntry;
        }
        return $this;
    }
    /**
     * Add item to JournalEntry value
     * @throws \InvalidArgumentException
     * @param \StructType\JournalEntry $item
     * @return \ArrayType\ArrayOfJournalEntry
     */
    public function addToJournalEntry(\StructType\JournalEntry $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JournalEntry) {
            throw new \InvalidArgumentException(sprintf('The JournalEntry property can only contain items of type \StructType\JournalEntry, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->JournalEntry[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JournalEntry|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JournalEntry|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JournalEntry|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JournalEntry|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JournalEntry|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string JournalEntry
     */
    public function getAttributeName()
    {
        return 'JournalEntry';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfJournalEntry
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
