<?php

namespace ileven_\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderDetail StructType
 * @package Ileven_
 * @subpackage Structs
 * @version 0.1
 * @date 2019-01-13
 */
class Ileven_OrderDetail extends AbstractStructBase
{
    /**
     * The QTY
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $QTY;
    /**
     * The PRICE
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $PRICE;
    /**
     * The SKU
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SKU;
    /**
     * Constructor method for OrderDetail
     * @uses Ileven_OrderDetail::setQTY()
     * @uses Ileven_OrderDetail::setPRICE()
     * @uses Ileven_OrderDetail::setSKU()
     * @param float $qTY
     * @param float $pRICE
     * @param string $sKU
     */
    public function __construct($qTY = null, $pRICE = null, $sKU = null)
    {
        $this
            ->setQTY($qTY)
            ->setPRICE($pRICE)
            ->setSKU($sKU);
    }
    /**
     * Get QTY value
     * @return float
     */
    public function getQTY()
    {
        return $this->QTY;
    }
    /**
     * Set QTY value
     * @param float $qTY
     * @return \ileven_\StructType\Ileven_OrderDetail
     */
    public function setQTY($qTY = null)
    {
        // validation for constraint: float
        if (!is_null($qTY) && !(is_float($qTY) || is_numeric($qTY))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($qTY, true), gettype($qTY)), __LINE__);
        }
        $this->QTY = $qTY;
        return $this;
    }
    /**
     * Get PRICE value
     * @return float
     */
    public function getPRICE()
    {
        return $this->PRICE;
    }
    /**
     * Set PRICE value
     * @param float $pRICE
     * @return \ileven_\StructType\Ileven_OrderDetail
     */
    public function setPRICE($pRICE = null)
    {
        // validation for constraint: float
        if (!is_null($pRICE) && !(is_float($pRICE) || is_numeric($pRICE))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($pRICE, true), gettype($pRICE)), __LINE__);
        }
        $this->PRICE = $pRICE;
        return $this;
    }
    /**
     * Get SKU value
     * @return string|null
     */
    public function getSKU()
    {
        return $this->SKU;
    }
    /**
     * Set SKU value
     * @param string $sKU
     * @return \ileven_\StructType\Ileven_OrderDetail
     */
    public function setSKU($sKU = null)
    {
        // validation for constraint: string
        if (!is_null($sKU) && !is_string($sKU)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sKU, true), gettype($sKU)), __LINE__);
        }
        $this->SKU = $sKU;
        return $this;
    }
}
