<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://85.182.131.125/sepa-ws-test/v3/sit_ws.asmx?WSDL',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://85.182.131.125/sepa-ws-test/v3/sit_ws.asmx?WSDL',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Registry ServiceType
 */
$registry = new \ServiceType\Registry($options);
/**
 * Sample call for registry operation/method
 */
if ($registry->registry(new \StructType\Registry()) !== false) {
    print_r($registry->getResult());
} else {
    print_r($registry->getLastError());
}
/**
 * Samples for Check ServiceType
 */
$check = new \ServiceType\Check($options);
/**
 * Sample call for checkAddressData operation/method
 */
if ($check->checkAddressData(new \StructType\CheckAddressData()) !== false) {
    print_r($check->getResult());
} else {
    print_r($check->getLastError());
}
/**
 * Sample call for checkCustomerData operation/method
 */
if ($check->checkCustomerData(new \StructType\CheckCustomerData()) !== false) {
    print_r($check->getResult());
} else {
    print_r($check->getLastError());
}
/**
 * Sample call for checkBankData operation/method
 */
if ($check->checkBankData(new \StructType\CheckBankData()) !== false) {
    print_r($check->getResult());
} else {
    print_r($check->getLastError());
}
/**
 * Sample call for checkCreditRating operation/method
 */
if ($check->checkCreditRating(new \StructType\CheckCreditRating()) !== false) {
    print_r($check->getResult());
} else {
    print_r($check->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for getBic4Iban operation/method
 */
if ($get->getBic4Iban(new \StructType\GetBic4Iban()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Insurance ServiceType
 */
$insurance = new \ServiceType\Insurance($options);
/**
 * Sample call for insuranceValidation operation/method
 */
if ($insurance->insuranceValidation(new \StructType\InsuranceValidation()) !== false) {
    print_r($insurance->getResult());
} else {
    print_r($insurance->getLastError());
}
/**
 * Samples for Insert ServiceType
 */
$insert = new \ServiceType\Insert($options);
/**
 * Sample call for insertMandate operation/method
 */
if ($insert->insertMandate(new \StructType\InsertMandate()) !== false) {
    print_r($insert->getResult());
} else {
    print_r($insert->getLastError());
}
/**
 * Sample call for insertPayment operation/method
 */
if ($insert->insertPayment(new \StructType\InsertPayment()) !== false) {
    print_r($insert->getResult());
} else {
    print_r($insert->getLastError());
}
/**
 * Samples for Verify ServiceType
 */
$verify = new \ServiceType\Verify($options);
/**
 * Sample call for verifyMandate operation/method
 */
if ($verify->verifyMandate(new \StructType\VerifyMandate()) !== false) {
    print_r($verify->getResult());
} else {
    print_r($verify->getLastError());
}
/**
 * Samples for Confirm ServiceType
 */
$confirm = new \ServiceType\Confirm($options);
/**
 * Sample call for confirmMandate operation/method
 */
if ($confirm->confirmMandate(new \StructType\ConfirmMandate()) !== false) {
    print_r($confirm->getResult());
} else {
    print_r($confirm->getLastError());
}
/**
 * Sample call for confirmAccessCode operation/method
 */
if ($confirm->confirmAccessCode(new \StructType\ConfirmAccessCode()) !== false) {
    print_r($confirm->getResult());
} else {
    print_r($confirm->getLastError());
}
/**
 * Samples for Cancel ServiceType
 */
$cancel = new \ServiceType\Cancel($options);
/**
 * Sample call for cancelPayment operation/method
 */
if ($cancel->cancelPayment(new \StructType\CancelPayment()) !== false) {
    print_r($cancel->getResult());
} else {
    print_r($cancel->getLastError());
}
/**
 * Samples for Retrieve ServiceType
 */
$retrieve = new \ServiceType\Retrieve($options);
/**
 * Sample call for retrieveCustomerData operation/method
 */
if ($retrieve->retrieveCustomerData(new \StructType\RetrieveCustomerData()) !== false) {
    print_r($retrieve->getResult());
} else {
    print_r($retrieve->getLastError());
}
/**
 * Samples for Update ServiceType
 */
$update = new \ServiceType\Update($options);
/**
 * Sample call for updateCustomerData operation/method
 */
if ($update->updateCustomerData(new \StructType\UpdateCustomerData()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Samples for Block ServiceType
 */
$block = new \ServiceType\Block($options);
/**
 * Sample call for blockCustomerData operation/method
 */
if ($block->blockCustomerData(new \StructType\BlockCustomerData()) !== false) {
    print_r($block->getResult());
} else {
    print_r($block->getLastError());
}
/**
 * Samples for Delete ServiceType
 */
$delete = new \ServiceType\Delete($options);
/**
 * Sample call for deleteCustomerData operation/method
 */
if ($delete->deleteCustomerData(new \StructType\DeleteCustomerData()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
