<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Insert ServiceType
 * @subpackage Services
 */
class Insert extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named insertMandate
     * Meta information extracted from the WSDL
     * - documentation: Registrierung und Anlage eines neuen SEPA Mandats
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\InsertMandate $parameters
     * @return \StructType\InsertMandateResponse|bool
     */
    public function insertMandate(\StructType\InsertMandate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->insertMandate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named insertPayment
     * Meta information extracted from the WSDL
     * - documentation: Anlage einer SEPA Zahlung
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\InsertPayment $parameters
     * @return \StructType\InsertPaymentResponse|bool
     */
    public function insertPayment(\StructType\InsertPayment $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->insertPayment($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\InsertMandateResponse|\StructType\InsertPaymentResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
