<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Check ServiceType
 * @subpackage Services
 */
class Check extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named checkAddressData
     * Meta information extracted from the WSDL
     * - documentation: Überprüfung von Adressendaten
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CheckAddressData $parameters
     * @return \StructType\CheckAddressDataResponse|bool
     */
    public function checkAddressData(\StructType\CheckAddressData $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->checkAddressData($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named checkCustomerData
     * Meta information extracted from the WSDL
     * - documentation: Überprüfung der Kundendaten
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CheckCustomerData $parameters
     * @return \StructType\CheckCustomerDataResponse|bool
     */
    public function checkCustomerData(\StructType\CheckCustomerData $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->checkCustomerData($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named checkBankData
     * Meta information extracted from the WSDL
     * - documentation: Überprüfung der Bankverbindung
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CheckBankData $parameters
     * @return \StructType\CheckBankDataResponse|bool
     */
    public function checkBankData(\StructType\CheckBankData $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->checkBankData($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named checkCreditRating
     * Meta information extracted from the WSDL
     * - documentation: Überprüfung der Bonität eines Kunden
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CheckCreditRating $parameters
     * @return \StructType\CheckCreditRatingResponse|bool
     */
    public function checkCreditRating(\StructType\CheckCreditRating $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->checkCreditRating($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\CheckAddressDataResponse|\StructType\CheckBankDataResponse|\StructType\CheckCreditRatingResponse|\StructType\CheckCustomerDataResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
