<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Block ServiceType
 * @subpackage Services
 */
class Block extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named blockCustomerData
     * Meta information extracted from the WSDL
     * - documentation: Kundendaten werden gesperrt
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\BlockCustomerData $parameters
     * @return \StructType\BlockCustomerDataResponse|bool
     */
    public function blockCustomerData(\StructType\BlockCustomerData $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->blockCustomerData($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\BlockCustomerDataResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
